<?php

use App\Http\Controllers\ReferralVoucher\ReferralVouchersController;
use Illuminate\Support\Facades\Route;

Route::resource('referral-vouchers', ReferralVouchersController::class);

Route::group(['prefix' => 'referral-vouchers'], function () {
  Route::any('/delete', [ReferralVouchersController::class, 'destroy'])->name('referral-vouchers.destroy');
  Route::any('/print/{id}', [ReferralVouchersController::class, 'printDoctorStatement'])->name('referral-vouchers.print');
});
  Route::any('referral-vouchers-overall-statement', [ReferralVouchersController::class, 'overAllStatement'])->name('referral-vouchers-overall-statement');
  Route::any('export-referral-vouchers-statement', [ReferralVouchersController::class, 'exportOverAllStatement'])->name('export-referral-vouchers-statement');

Route::get('dr-referral-list', [ReferralVouchersController::class,'drReferralList'])->name('dr-referral-list');
Route::get('dr-referral-statement/{id}', [ReferralVouchersController::class,'overAllStatement'])->name('dr-referral-statement');
Route::post('search-referral-doctors', [ReferralVouchersController::class, 'searchDoctors'])->name('search-referral-doctors');

Route::get('lab-referral-list', [ReferralVouchersController::class,'labReferralList'])->name('lab-referral-list');
Route::get('lab-referral-statement/{id}', [ReferralVouchersController::class,'labOverAllStatement'])->name('lab-referral-statement');
Route::post('search-referral-lab', [ReferralVouchersController::class, 'searchLab'])->name('search-referral-lab');
  Route::any('export-referral-lab-statement', [ReferralVouchersController::class, 'exportLabStatement'])->name('export-referral-lab-statement');

Route::get('agent-referral-list', [ReferralVouchersController::class,'agentReferralList'])->name('agent-referral-list');
Route::get('agent-referral-statement/{id}', [ReferralVouchersController::class,'agentOverAllStatement'])->name('agent-referral-statement');
Route::post('search-referral-agents', [ReferralVouchersController::class, 'searchAgents'])->name('search-referral-agents');
  Route::any('export-referral-agent-statement', [ReferralVouchersController::class, 'exportAgentStatement'])->name('export-referral-agent-statement');