<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Sales\SaleReturnController;



/**************************Sale Return Route ***************************/
//Route::resource('sale-return', SaleReturnController::class);
Route::group(['prefix' => 'sale-return'], function () {
   Route::get('/',[SaleReturnController::class,'index'])->name('sale-return.index');
   Route::any('/create/{id}', [SaleReturnController::class, 'create'])->name('sale-return.create');
   Route::any('cart-product-remove', [SaleReturnController::class, 'cartProductRemove'])->name('sale-return-cart-product-remove');
   Route::get('cart-billing', [SaleReturnController::class, 'billing'])->name('sale-return-cart-billing');
   Route::any('sale-return-product-add-to-cart', [SaleReturnController::class, 'productAddToCart'])->name('sale-return-product-add-to-cart');
   Route::any('product-cart/{invoice_id?}', [SaleReturnController::class, 'productCart'])->name('sale-return-product-cart');
   Route::any('cart-product-update', [SaleReturnController::class, 'cartProductUpdate'])->name('sale-return-cart-product-update');
   Route::post('store', [SaleReturnController::class, 'store'])->name('sale-return.store');
   Route::get('invoice/{id}', [SaleReturnController::class, 'invoice'])->name('sale-return-invoice');
   Route::any('delete', [SaleReturnController::class, 'destroy'])->name('sale-return.destroy');
   Route::get('edit/{id}', [SaleReturnController::class, 'edit'])->name('sale-return.edit');
   Route::get('edit-cart-billing/{invoice_id}', [SaleReturnController::class, 'editBilling'])->name('sale-return-edit-cart-billing');
   Route::any('update/{id}', [SaleReturnController::class, 'update'])->name('sale-return.update');
   Route::any('search-invoice-from', [SaleReturnController::class, 'searchInvoiceFrom'])->name('sale-return.search-invoice-from');
   Route::any('search-invoice', [SaleReturnController::class, 'searchInvoice'])->name('sale-return.search-invoice');
   Route::post('search-invoice-submit', [SaleReturnController::class, 'searchInvoiceStore'])->name('sale-return.search-invoice-store');
   Route::any('statement', [SaleReturnController::class, 'statement'])->name('sale-return.statement');
   Route::any('statement-export', [SaleReturnController::class, 'statementExport'])->name('sale-return.statement-export');
   Route::get('item-wise-statement', [SaleReturnController::class, 'itemWiseStatement'])->name('sale-return-item-wise.statement');
   Route::get('item-wise-statement-export', [SaleReturnController::class, 'itemWiseStatementExport'])->name('sale-return-item-wise.statement-export');
   Route::get('/single-product-statement/{id}', [SaleReturnController::class, 'singleProductStatement'])->name('sale-return.single-product-statement');

  

});
Route::post('customer-return-search-products', [SaleReturnController::class, 'searchReturnProducts'])->name('customer-return-search-products');
Route::get('/sale-return-item-selection/{id}', [SaleReturnController::class, 'itemSelection'])->name('sale-return-item-selection');

Route::any('/sale-return-item-selected-to-cart', [SaleReturnController::class, 'addToCartSelectedItem'])->name('sale-return-item-selected-to-cart');