<?php

use App\Http\Controllers\Sales\IpdSalesOrdersController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SalesController;

/************* Sale Route **********************/
Route::resource('sale', SalesController::class);
Route::any('sale/delete', [SalesController::class, 'destroy'])->name('sale.destroy');
//customer
Route::get('customer-account-create', [SalesController::class, 'customerCreate'])->name('customer-account-create');
Route::post('customer-account-store', [SalesController::class, 'storeCustomer'])->name('customer-account-store');
Route::get('customer-account-edit/{id}', [SalesController::class, 'customerEdit'])->name('customer-account-edit');
Route::post('customer-account-update/{id}', [SalesController::class, 'updateCustomer'])->name('customer-account-update');
//search product & account
Route::post('customer-account-search', [SalesController::class, 'searchCustomer'])->name('customer-account-search');
Route::post('customer-search-products', [SalesController::class, 'searchProducts'])->name('customer-search-products');

Route::get('supplier-account-create', [SalesController::class, 'supplierCreate'])->name('supplier-account-create');
Route::post('supplier-account-store', [SalesController::class, 'storeSupplier'])->name('supplier-account-store');
Route::get('supplier-account-edit/{id}', [SalesController::class, 'supplierEdit'])->name('supplier-account-edit');
Route::post('supplier-account-update/{id}', [SalesController::class, 'updateSupplier'])->name('supplier-account-update');
//search product & account
Route::post('supplier-account-search', [SalesController::class, 'searchSupplier'])->name('supplier-account-search');

Route::post('/get-batch-information', [SalesController::class,'getBatchInformation'])->name('get-batch-information');
Route::any('sale-cart-product-remove', [SalesController::class, 'cartProductRemove'])->name('sale-cart-product-remove');
Route::get('sale-cart-billing', [SalesController::class, 'billing'])->name('sale-cart-billing');
Route::any('sale-product-add-to-cart', [SalesController::class, 'productAddToCart'])->name('sale-product-add-to-cart');
Route::any('sale-product-cart/{invoice_id?}', [SalesController::class, 'productCart'])->name('sale-product-cart');
Route::any('sale-cart-product-update', [SalesController::class, 'cartProductUpdate'])->name('sale-cart-product-update');
 //invoice
Route::get('sale-invoice/{id}', [SalesController::class, 'saleInvoice'])->name('sale-invoice');
Route::get('sale-edit-cart-billing/{invoice_id}', [SalesController::class, 'SaleeditBilling'])->name('sale-edit-cart-billing');
 //collect
Route::get('sale-collection/{invoice_id}', [SalesController::class, 'saleCollection'])->name('sale-collection');
Route::post('update-sale-vouchers/{id}', [SalesController::class, 'saleCollectionUpdate'])->name('update-sale-vouchers');
Route::get('/get-payment-modes', [SalesController::class, 'getPaymentModes'])->name('getPaymentModes');
//sale statement
Route::get('sale-statement', [SalesController::class, 'saleStatement'])->name('sale-statement');
Route::get('sale-statement-export', [SalesController::class, 'saleStatementExport'])->name('sale-statement-export');

Route::get('consolidated-sale-statement', [SalesController::class, 'consolidatedSaleStatement'])->name('consolidated-sale-statement');
Route::get('item-wise-sales-statement', [SalesController::class, 'reportsAndInsights'])->name('item-wise-sales-statement');
Route::get('item-wise-sales-statement-export', [SalesController::class, 'reportsAndInsightsExport'])->name('item-wise-sales-statement-export');
Route::get('sales/single-product-statement/{id?}', [SalesController::class, 'singleProductStatement'])->name('sales.single-product-statement');

Route::get('work-book-register', [SalesController::class, 'workBookRegister'])->name('work-book-register');

//Bill To
Route::get('get-bill-to', [SalesController::class, 'getBillTo'])->name('getBillTo');
/*************************** update transaction*********************/
Route::any('sale/update-transaction', [SalesController::class, 'updateTransaction'])->name('update-transaction');

/**************************IPD SALE ORDERS Route ***************************/
Route::group(['prefix' => 'ipd-sale-orders'], function () {
    Route::get('/',[IpdSalesOrdersController::class,'index'])->name('ipd-sale-orders.index');
    Route::any('invoice/{id}/{batch_id}',[IpdSalesOrdersController::class,'invoice'])->name('ipd-sale-orders.invoice');
    Route::any('view/{id}/{batch_id}',[IpdSalesOrdersController::class,'edit'])->name('ipd-sale-orders.view');
    Route::any('product-cart/{id}/{batch_id}',[IpdSalesOrdersController::class,'productCart'])->name('ipd-sale-order-product-cart');
    Route::any('ipd-sale-order-cart-product-update', [IpdSalesOrdersController::class, 'cartProductUpdate'])->name('ipd-sale-order-cart-product-update');
    Route::get('ipd-sale-order-edit-cart-billing/{id}/{batch_id}', [IpdSalesOrdersController::class, 'editBilling'])->name('ipd-sale-order-edit-cart-billing');
    Route::any('/update/{id}/{batch_id}', [IpdSalesOrdersController::class, 'update'])->name('ipd-sale-order.update');
    Route::any('ipd-sale-order-product-add-to-cart', [IpdSalesOrdersController::class, 'productAddToCart'])->name('ipd-sale-order-product-add-to-cart');
});