<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Stocks\InventoryAndStockController;
use App\Http\Controllers\Stocks\OpeningStockController;
use App\Http\Controllers\Stocks\ProductShortListController;
use App\Http\Controllers\Stocks\StockInController;
use App\Http\Controllers\Stocks\StockMomentTypeController;
use App\Http\Controllers\Stocks\StockOutController;

/********************** Stock and Inventory ****************************/
Route::get('inventory-stock', [InventoryAndStockController::class, 'index'])->name('inventory-stock.index');

Route::group(['prefix' => 'inventory-stock'], function () {
    Route::any('statement', [InventoryAndStockController::class, 'statement'])->name('inventory-stock.statement');
    Route::any('statement-export', [InventoryAndStockController::class, 'statementExport'])->name('inventory-stock.statement-export');
    Route::get('get-current-stock',[InventoryAndStockController::class,'getCurrentStockAndPrimaryUnit'])->name('stock.current-stock');
    Route::any('expiry-statement', [InventoryAndStockController::class, 'expiryStatement'])->name('inventory-stock.expiry-statement');
    Route::any('reorder-list', [InventoryAndStockController::class, 'stockReorderList'])->name('inventory-stock.reorder-list');
    Route::any('reorder-list-export', [InventoryAndStockController::class, 'stockReorderListExport'])->name('inventory-stock.reorder-list-export');
    Route::get('single-product-statement/{id}', [InventoryAndStockController::class, 'singleProductStatement'])->name('inventory-stock.single-product-statement');
    Route::get('single-product-statement-export/{id?}', [InventoryAndStockController::class, 'singleProductStatementExport'])->name('inventory-stock.single-product-statement-export');
    Route::get('stock-in', [InventoryAndStockController::class, 'stockInStatement'])->name('inventory-stock.stock-in-list');
    Route::get('stock-out', [InventoryAndStockController::class, 'stockOutStatement'])->name('inventory-stock.stock-out-list');
});

/******************* Stock Moment Types *****************/
Route::resource('stock-movement-type', StockMomentTypeController::class);

Route::group(['prefix' => 'stock-movement-type'], function () {
    Route::any('/delete', [StockMomentTypeController::class, 'destroy'])->name('stock-movement-type.destroy');
    Route::any('/change-status', [StockMomentTypeController::class, 'changeStatus'])->name('stock-movement-type.changeStatus');
});
/******************** Stock In Route **************/
// Route::resource('stock-in',StockInController::class);
Route::group(['prefix' => 'stock-in'], function () {
    Route::get('/',[StockInController::class,'index'])->name('stock-in.index');
    Route::any('/create', [StockInController::class, 'create'])->name('stock-in.create');
    Route::post('store', [StockInController::class, 'store'])->name('stock-in.store');
    Route::get('edit/{id}', [StockInController::class, 'edit'])->name('stock-in.edit');
    Route::any('purchase-product-add-to-cart', [StockInController::class, 'productAddToCart'])->name('stock-in.product-add-to-cart');
    Route::any('stock/product-cart/{invoice_id?}', [StockInController::class, 'productCart'])->name('stock-in.product-cart');
    Route::any('cart-product-update', [StockInController::class, 'cartProductUpdate'])->name('stock-in.cart-product-update');
    Route::any('cart-product-remove', [StockInController::class, 'cartProductRemove'])->name('stock-in.cart-product-remove');
    Route::post('search-products', [StockInController::class, 'searchProducts'])->name('stock-in.search-products');

    Route::get('store', [StockInController::class, 'store'])->name('stock-in.store');
    Route::any('updates/{id}', [StockInController::class, 'update'])->name('stock-in.update');
    Route::any('/delete', [StockInController::class, 'destroy'])->name('stock-in.destroy');
    Route::get('invoice/{id}', [StockInController::class, 'invoice'])->name('stock-in.invoice');
    Route::any('statement', [StockInController::class, 'statement'])->name('stock-in.statement');
    Route::any('statement-export', [StockInController::class, 'statementExport'])->name('stock-in.statement-export');

});


/******************** Stock OUT Route **************/
Route::group(['prefix' => 'stock-out'], function () {
    Route::get('/',[StockOutController::class,'index'])->name('stock-out.index');
    Route::any('/create', [StockOutController::class, 'create'])->name('stock-out.create');
    Route::post('store', [StockOutController::class, 'store'])->name('stock-out.store');
    Route::get('edit/{id}', [StockOutController::class, 'edit'])->name('stock-out.edit');
    Route::any('purchase-product-add-to-cart', [StockOutController::class, 'productAddToCart'])->name('stock-out.product-add-to-cart');
    Route::any('stock-out/product-cart/{invoice_id?}', [StockOutController::class, 'productCart'])->name('stock-out.product-cart');
    Route::any('cart-product-update', [StockOutController::class, 'cartProductUpdate'])->name('stock-out.cart-product-update');
    Route::any('cart-product-remove', [StockOutController::class, 'cartProductRemove'])->name('stock-out.cart-product-remove');
    Route::post('search-products', [StockOutController::class, 'searchProducts'])->name('stock-out.search-products');
    Route::get('store', [StockOutController::class, 'store'])->name('stock-out.store');
    Route::any('updates/{id}', [StockOutController::class, 'update'])->name('stock-out.update');
    Route::any('/delete', [StockOutController::class, 'destroy'])->name('stock-out.destroy');
    Route::get('invoice/{id}', [StockOutController::class, 'invoice'])->name('stock-out.invoice');

    Route::any('statement', [StockOutController::class, 'statement'])->name('stock-out.statement');
    Route::any('statement-export', [StockOutController::class, 'statementExport'])->name('stock-out.statement-export');

});

/**************** Opening Stock Route ********************/
Route::group(['prefix' => 'opening-stock'], function () {
    Route::get('/',[OpeningStockController::class,'index'])->name('opening-stock.index');
    Route::any('process-to-stock-in',[OpeningStockController::class,'processToStockIn'])->name('opening-stock.process');
});
/********************** Product Short List ***********************/
Route::group(['prefix' => 'stock-short-list'], function () {
    Route::get('/',[ProductShortListController::class,'index'])->name('stock-short-list.index');
    Route::any('/store',[ProductShortListController::class,'store'])->name('stock-short-list.store');
    Route::any('/delete', [ProductShortListController::class, 'destroy'])->name('stock-short-list.destroy');
    Route::get('statement',[ProductShortListController::class,'statement'])->name('stock-short-list.statement');
});

