<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\StudentHousesController;
use App\Http\Controllers\StudentsController;
use App\Http\Controllers\FacultyController;

   /************ Students Manager *************/

   // Student House
   Route::resource('student-house', StudentHousesController::class);
   Route::any('student-house/status', [StudentHousesController::class, 'changeStatus'])->name('student-house.changeStatus');

   // Student Information
   Route::resource('students', StudentsController::class);
   Route::any('student/export', [StudentsController::class, 'export'])->name('students.export');
   Route::any('student/import', [StudentsController::class, 'import'])->name('students.import');
   Route::any('student/import/store', [StudentsController::class, 'importStore'])->name('students.import-store');
   Route::any('student/statements', [StudentsController::class, 'statements'])->name('students.statements');

   Route::match(['GET', 'POST'], '/student-bulk-list', [StudentsController::class, 'bulklist'])->name('student-bulk-list');
   Route::match(['GET', 'POST'], '/student-bulk-list-edit/{id}', [StudentsController::class, 'bulkedit'])->name('student-bulk-list-edit');
   Route::any('/student-bulk-list-update/{id}', [StudentsController::class, 'bulkupdate'])->name('student-bulk-list-update');
   Route::match(['GET', 'POST'], '/bulktostudent', [StudentsController::class, 'bulktostudent'])->name('bulktostudent');
   Route::any('/student-bulk-list-delete', [StudentsController::class, 'bulkdelete'])->name('student-bulk-list.temp.destroy');

   Route::match(['GET', 'POST'], '/check_error_student', [StudentsController::class, 'check_error'])->name('check_error_student');

 	// Faculty
   Route::resource('faculty', FacultyController::class);
   // End LMS - Routes