<?php

use App\Http\Controllers\StudyMaterialsController;
use Illuminate\Support\Facades\Route;

Route::resource('/study-materials', StudyMaterialsController::class);
Route::post('study-materials/changeStatus', [StudyMaterialsController::class, 'changeStatus'])->name('study-materials-changestatus');
Route::post('study-materials/isDefaultchangeStatus', [StudyMaterialsController::class, 'isDefaultchangeStatus'])->name('study-materials-isDefaultchangeStatus');
Route::get('study-materials-create', [StudyMaterialsController::class, 'createStudyMaterials'])->name('study-materials-create');
Route::post('study-materials-store', [StudyMaterialsController::class, 'storeStudyMaterials'])->name('study-materials-store');
Route::put('study-materials-update/{id}', [StudyMaterialsController::class, 'updateStudyMaterials'])->name('study-materials-update');

Route::get('study-materials-table/{course_id}', [StudyMaterialsController::class, 'table'])->name('study-materials-table');
Route::get('study-materials-file/create/{id}', [StudyMaterialsController::class, 'fileCreate'])->name('study-materials-file.create');
Route::post('study-materials-file/store', [StudyMaterialsController::class, 'fileStore'])->name('study-materials-file.store');

Route::get('study-materials-file/show/{course_id}/{material_type_id}/{material_id}', [StudyMaterialsController::class, 'fileShow'])->name('study-materials-file.show');
Route::any('study-materials-file/destroy/{id}', [StudyMaterialsController::class, 'fileDestroy'])->name('study-materials-flies.destroy');















	