<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SurgeriesController;
use App\Http\Controllers\Accounts\AccountsController;



///MAIN ROUTE///
Route::resource('/ipd-surgeries', SurgeriesController::class);

///SURGERIES///
Route::get('/ipd-surgeries-list/{id}', [SurgeriesController::class, 'surgeries'])->name('ipd-surgeries.index');
Route::post('/ipd-surgeries-store/{id}', [SurgeriesController::class, 'store'])->name('ipd-surgeries.store');
Route::get('/ipd-surgeries-create/{id}', [SurgeriesController::class, 'create'])->name('ipd-surgeries.create');
Route::get('/ipd-surgeries-edit/{id}', [SurgeriesController::class, 'edit'])->name('ipd-surgeries.edit');
Route::put('ipd-surgeries-account-update/{id}', [SurgeriesController::class, 'updateSurgeries'])->name('ipd-surgeries-account-update');

///DOCTOR///
Route::get('doctor-account-create', [AccountsController::class, 'createDoctor'])->name('doctor-account-create');
Route::post('doctor-account-store', [AccountsController::class, 'storeDoctor'])->name('doctor-account-store');
Route::get('doctor-account-edit/{id}', [AccountsController::class, 'EditDoctorDetails'])->name('doctor-account-edit');
Route::post('doctor-account-update/{id}', [AccountsController::class, 'updateDoctorDetails'])->name('doctor-account-update');

///CHANGE STATUS///
// Route::post('ipd-surgeries/changeStatus', [SurgeriesController::class, 'changeStatus'])->name('ipd-surgeries-changestatus');


///SURGERY TEAM///
Route::get('/ipd-surgeries-assign-team/{id}', [SurgeriesController::class, 'assignTeam'])->name('ipd-surgeries-assign-team.create');
Route::post('surgery-team-store/{id}', [SurgeriesController::class, 'storeSurgeryTeam'])->name('surgery-team-store');
Route::delete('surgery-team-destroy/{id}', [SurgeriesController::class, 'destroyAssignTeam'])->name('surgery-team-destroy');

///SURGERY Anesthesia///
Route::get('/ipd-surgeries-anesthesia-create/{id}', [SurgeriesController::class, 'anesthesiaCreate'])->name('ipd-surgeries-anesthesia-create');
Route::post('surgery-anesthesia-store/{id}', [SurgeriesController::class, 'storeSurgeryAnesthesia'])->name('surgery-anesthesia-store');













