<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TaskManager\TasksController;
use App\Http\Controllers\TaskManager\TaskTeamsController;
use App\Http\Controllers\TaskManager\TaskGroupsController;
use App\Http\Controllers\TaskManager\PipelineStagesController;
use App\Http\Controllers\TaskManager\CommentsController;

//Task Manager
Route::resource('/task-manager', TasksController::class);
Route::prefix('/task-manager/')->group(function () {
    Route::any('/delete', [TasksController::class, 'destroy'])->name('task-manager.destroy');
    Route::get('/client-tasks/{id}', [TasksController::class, 'clientTask'])->name('task-manager.client-tasks');
});
Route::post('/store-task-status/{id}', [TasksController::class, 'storeTaskStatus'])->name('store-task-status');

// Task Groups
Route::resource('/task-groups', TaskGroupsController::class);
Route::get('task-groups-account-create', [TaskGroupsController::class, 'createTaskGroup'])->name('task-groups-account-create');
Route::post('task-groups-account-store', [TaskGroupsController::class, 'storeTaskGroup'])->name('task-groups-account-store');
Route::put('task-groups-account-update/{id}', [TaskGroupsController::class, 'updateTaskGroup'])->name('task-groups-account-update');
Route::post('task-groups/changeStatus', [TaskGroupsController::class, 'changeStatus'])
    ->name('task-groups-changestatus');

// Pipeline Stages
Route::resource('/pipeline-stages', PipelineStagesController::class);
Route::get('pipeline-stages-account-create', [PipelineStagesController::class, 'createPipelineStage'])->name('pipeline-stages-account-create');
Route::post('pipeline-stages-account-store', [PipelineStagesController::class, 'storePipelineStage'])->name('pipeline-stages-account-store');
Route::put('pipeline-stages-account-update/{id}', [PipelineStagesController::class, 'updatePipelineStage'])->name('pipeline-stages-account-update');
Route::post('pipeline-stages/changeStatus', [PipelineStagesController::class, 'changeStatus'])
    ->name('pipeline-stages-changestatus');

// Task Teams
Route::resource('task-teams', TaskTeamsController::class);
Route::get('task-teams-account-create', [TaskTeamsController::class, 'createTaskTeam'])->name('task-teams-account-create');
Route::post('task-teams-account-store', [TaskTeamsController::class, 'storeTaskTeam'])->name('task-teams-account-store');
Route::put('task-teams-account-update/{id}', [TaskTeamsController::class, 'updateTaskTeam'])->name('task-teams-account-update');
Route::get('reject-reason-create/{id}', [TaskTeamsController::class, 'createRejectReason'])->name('reject-reason-create');
Route::post('reject-reason-store/{id}', [TaskTeamsController::class, 'storeRejectReason'])->name('reject-reason-store');
Route::post('task-teams/changeStatus', [TaskTeamsController::class, 'changeStatus'])->name('task-teams-changestatus');

Route::prefix('/task/')->group(function () {
    Route::get('/task-comments/{id}', [CommentsController::class, 'index'])->name('task.comments');
});

/**********************************  Task comments  ************************************/
Route::resource('task-comments', CommentsController::class);
Route::group(['prefix' => 'task-comments'], function () {
   Route::any('/delete', [CommentsController::class, 'destroy'])->name('task-comments.destroy');
});

Route::post('task-search-users', [TasksController::class, 'searchUsers'])->name('task-search-users');
Route::post('task-client-search', [TasksController::class, 'searchClient'])->name('task-client-search');

Route::post('task-group-stages', [PipelineStagesController::class, 'searchStages'])->name('task-group-stages');
