<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TaxMaster\taxCalculationController;
use App\Http\Controllers\TaxMaster\TaxCategoryController;
use App\Http\Controllers\TaxMaster\TaxMasterController;
use App\Http\Controllers\TaxMaster\TaxMasterSubController;


   /******************************* Tax Category ****************************************/
   Route::resource('tax-categories', TaxCategoryController::class);
   Route::group(['prefix' => 'tax-categories'], function () {
      Route::get('/list', [TaxCategoryController::class, 'list']);
      Route::any('/delete', [TaxCategoryController::class, 'destroy'])->name('tax-categories.destroy');
      Route::any('/changestatus', [TaxCategoryController::class, 'changeStatus'])->name('tax-categories.changestatus');
      Route::any('/changedefault', [TaxCategoryController::class, 'changeDefault'])->name('tax-categories.changedefault');
   });
   /***************************** Tax Masters  *************************************/
   Route::resource('tax-masters', TaxMasterController::class);
   Route::group(['prefix' => 'tax-masters'], function () {
      Route::get('/list', [TaxMasterController::class, 'list']);
      Route::any('/delete', [TaxMasterController::class, 'destroy'])->name('tax-masters.destroy');
      Route::any('/changestatus', [TaxMasterController::class, 'changeStatus'])->name('tax-masters.changestatus');
      Route::any('/changedefault', [TaxMasterController::class, 'changedefault'])->name('tax-masters.changedefault');
   });
   /******************************** Tax Masters Sub  **************************************/
   Route::resource('tax-masters-sub', TaxMasterSubController::class);
   Route::group(['prefix' => 'tax-masters-sub'], function () {
      Route::get('/list', [TaxMasterSubController::class, 'list']);
      Route::any('/delete', [TaxMasterSubController::class, 'destroy'])->name('tax-masters-sub.destroy');
      Route::any('/changestatus', [TaxMasterSubController::class, 'changeStatus'])->name('tax-masters-sub.changestatus');
      Route::any('/changedefault', [TaxMasterSubController::class, 'changedefault'])->name('tax-masters-sub.changedefault');
   });
   Route::get('tax-sub-masters/{id}', [TaxMasterSubController::class, 'index'])->name('tax-sub-masters.index');

   /****************************** Tax Calculation  ************************************/
   Route::resource('tax-calculation', taxCalculationController::class);
   Route::group(['prefix' => 'tax-calculation'], function () {
      Route::get('/list', [taxCalculationController::class, 'list']);
      Route::any('/delete', [taxCalculationController::class, 'destroy'])->name('tax-calculation.destroy');
      Route::any('/changestatus', [taxCalculationController::class, 'changeStatus'])->name('tax-calculation.changestatus');
      Route::any('/changedefault', [taxCalculationController::class, 'changedefault'])->name('tax-calculation.changedefault');
   });
