<?php

use App\Http\Controllers\TestItemTemplateController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TestManager\TestPackagesController;
use App\Http\Controllers\TestManager\TestPackageGroupsController;
use App\Http\Controllers\TestManager\TestItemsController;
use App\Http\Controllers\TestManager\TestItemOptionsController;
use App\Http\Controllers\TestManager\TestItemNormalRangesController;
use App\Http\Controllers\TestManager\TestUnitsController;
use App\Http\Controllers\TestManager\TestMethodsController;
use App\Http\Controllers\TestManager\DepartmentsController;
use App\Http\Controllers\TestManager\SampleTypesController;
use App\Http\Controllers\TestManager\SampleCollectionTubesController;
use App\Http\Controllers\TestManager\StyleTypesController;
use App\Http\Controllers\TestManager\SpecialCasesController;
use App\Http\Controllers\TestManager\MachineAndEquipmentsController;
use App\Http\Controllers\TestManager\SignaturesController;

   /********************************** Test-packages ***********************************/
   Route::resource('test-packages', TestPackagesController::class);
   Route::prefix('/test-packages/')->group(function () {
      Route::any('/delete', [TestPackagesController::class, 'destroy'])->name('test-packages.destroy');
      Route::any('/change-status', [TestPackagesController::class, 'changeStatus'])->name('test-packages.changestatus');
      Route::any('/show-report', [TestPackagesController::class, 'showReport'])->name('test-packages.showreport');
      Route::any('/page-break', [TestPackagesController::class, 'pageBreak'])->name('test-packages.pagebreak');

      

      // IMPORT/EXPORT
      Route::any('/import/create', [TestPackagesController::class, 'importCreate'])->name('test-packages.import-create');
      Route::any('/import/preview', [TestPackagesController::class, 'importPreview'])->name('test-packages.import-preview');
      Route::any('/store/import', [TestPackagesController::class, 'importStore'])->name('test-packages.import-store');
      Route::any('/export/format', [TestPackagesController::class, 'exportFormat'])->name('test-packages.export-format');
      Route::any('/import/session/delete', [TestPackagesController::class, 'importSessionDestroy'])->name('test-packages.import-session-destroy');
   });
   Route::any('/test-package-product-link/{id}', [TestPackagesController::class, 'productLink'])->name('test-packages.product-link');
   Route::get('selected-test-products', [TestPackagesController::class, 'getSelectedTestProducts'])->name('selected-test-products');
   Route::post('product-test-product/store', [TestPackagesController::class, 'testProductStore'])->name('product-test-product.store');

   Route::any('test-package-products/{id}', [TestPackagesController::class, 'testPackageProducts'])->name('test-package-products');

   /***************************** Test-package-groups *********************************/
   Route::prefix('test-package-groups')->group(function () {
      Route::any('/test-delete/{id?}', [TestPackageGroupsController::class, 'testDestroy'])->name('test-package-groups.test-destroy');
      Route::any('reorder/test_items', [TestPackageGroupsController::class, 'reorderTestItems'])->name('reorder-test-items');

      // Test Package Group Notes
      Route::any('/note-edit/{id?}', [TestPackageGroupsController::class, 'noteEdit'])->name('test-package-groups.note-edit');
      Route::post('/note-update/{id?}', [TestPackageGroupsController::class, 'noteUpdate'])->name('test-package-groups.note-update');
      Route::any('/note-change-status', [TestPackageGroupsController::class, 'noteChangeStatus'])->name('test-package-groups.note_changestatus');

      // Test Package Notes
      Route::any('/package/note-edit/{id?}', [TestPackageGroupsController::class, 'packageNoteEdit'])->name('test-package.package-note-edit');
      Route::post('/package/note-update/{id?}', [TestPackageGroupsController::class, 'packageNoteUpdate'])->name('test-package.package-note-update');
      Route::any('/package/note-change-status', [TestPackageGroupsController::class, 'packageNoteChangeStatus'])->name('test-package.package-note_changestatus');

      // Test Package Groups
      Route::any('/create/{id?}', [TestPackageGroupsController::class, 'create'])->name('test-package-groups.create');
      Route::any('/store', [TestPackageGroupsController::class, 'store'])->name('test-package-groups.store');
      Route::any('/edit/{id?}', [TestPackageGroupsController::class, 'edit'])->name('test-package-groups.edit');
      Route::any('/update/{id?}', [TestPackageGroupsController::class, 'update'])->name('test-package-groups.update');
      Route::any('/change-status', [TestPackageGroupsController::class, 'changeStatus'])->name('test-package-groups.changestatus');
      Route::any('/delete/{id?}', [TestPackageGroupsController::class, 'destroy'])->name('test-package-groups.destroy');
      Route::any('/{id?}', [TestPackageGroupsController::class, 'index'])->name('test-package-groups.index');
   });

   /********************************** Test-Items **************************************/
   Route::prefix('/test-items/')->group(function () {
      Route::any('/{id}/create', [TestItemsController::class, 'create'])->name('test-items.create');
      Route::any('/{id}/store', [TestItemsController::class, 'store'])->name('test-items.store');
      Route::any('/{id}/edit', [TestItemsController::class, 'edit'])->name('test-items.edit');
      Route::any('/{id}/update', [TestItemsController::class, 'update'])->name('test-items.update');
      Route::any('/delete', [TestItemsController::class, 'destroy'])->name('test-items.destroy');
      Route::any('/change-status', [TestItemsController::class, 'changeStatus'])->name('test-items.changestatus');
      Route::any('/changePageBreakstatus', [TestItemsController::class, 'changePageBreakstatus'])->name('test-items.changePageBreakstatus');
      Route::any('/read-only', [TestItemsController::class, 'readOnly'])->name('test-items.readonly');
      Route::any('/item-show/{id?}', [TestItemsController::class, 'show'])->name('test-items.detail');

      // IMPORT/EXPORT
      Route::any('/import/{id}/create', [TestItemsController::class, 'importCreate'])->name('test-items.import-create');
      Route::any('/import/preview', [TestItemsController::class, 'importPreview'])->name('test-items.import-preview');
      Route::any('/store/{id}/import', [TestItemsController::class, 'importStore'])->name('test-items.import-store');
      Route::any('/export/format', [TestItemsController::class, 'exportFormat'])->name('test-items.export-format');
      Route::any('/import/session/delete', [TestItemsController::class, 'importSessionDestroy'])->name('test-items.import-session-destroy');
   });

   /******************************** Test Item Options **************************************/
   Route::prefix('/test-item-options/')->group(function () {
      Route::any('/{id?}/index', [TestItemOptionsController::class, 'index'])->name('test-item-options.index');
      Route::any('/create/{id?}', [TestItemOptionsController::class, 'create'])->name('test-item-options.create');
      Route::any('/{id?}/store', [TestItemOptionsController::class, 'store'])->name('test-item-options.store');
      Route::any('/{id?}/edit', [TestItemOptionsController::class, 'edit'])->name('test-item-options.edit');
      Route::any('/{id?}/update', [TestItemOptionsController::class, 'update'])->name('test-item-options.update');
      Route::any('/delete', [TestItemOptionsController::class, 'destroy'])->name('test-item-options.destroy');
      Route::any('/change-status', [TestItemOptionsController::class, 'changeStatus'])->name('test-item-options.changestatus');

      // IMPORT/EXPORT
      Route::any('/import/{id}/create', [TestItemOptionsController::class, 'importCreate'])->name('test-item-options.import-create');
      Route::any('/import/preview', [TestItemOptionsController::class, 'importPreview'])->name('test-item-options.import-preview');
      Route::any('/store/{id}/import', [TestItemOptionsController::class, 'importStore'])->name('test-item-options.import-store');
      Route::any('/export/format', [TestItemOptionsController::class, 'exportFormat'])->name('test-item-options.export-format');
      Route::any('/import/session/delete', [TestItemOptionsController::class, 'importSessionDestroy'])->name('test-item-options.import-session-destroy');
   });

   /******************************** Test Item Normal Ranges **************************************/
   Route::prefix('/test-item-normal-ranges/')->group(function () {
      Route::any('/{id?}/index', [TestItemNormalRangesController::class, 'index'])->name('test-item-normal-ranges.index');
      Route::any('/create/{id?}', [TestItemNormalRangesController::class, 'create'])->name('test-item-normal-ranges.create');
      Route::any('/{id?}/store', [TestItemNormalRangesController::class, 'store'])->name('test-item-normal-ranges.store');
      Route::any('/{id?}/edit', [TestItemNormalRangesController::class, 'edit'])->name('test-item-normal-ranges.edit');
      Route::any('/{id?}/update', [TestItemNormalRangesController::class, 'update'])->name('test-item-normal-ranges.update');
      Route::any('/delete', [TestItemNormalRangesController::class, 'destroy'])->name('test-item-normal-ranges.destroy');
      Route::any('/change-status', [TestItemNormalRangesController::class, 'changeStatus'])->name('test-item-normal-ranges.changestatus');

      // IMPORT/EXPORT
      Route::any('/import/{id}/create', [TestItemNormalRangesController::class, 'importCreate'])->name('test-item-normal-ranges.import-create');
      Route::any('/import/preview', [TestItemNormalRangesController::class, 'importPreview'])->name('test-item-normal-ranges.import-preview');
      Route::any('/store/{id}/import', [TestItemNormalRangesController::class, 'importStore'])->name('test-item-normal-ranges.import-store');
      Route::any('/export/format', [TestItemNormalRangesController::class, 'exportFormat'])->name('test-item-normal-ranges.export-format');
      Route::any('/import/session/delete', [TestItemNormalRangesController::class, 'importSessionDestroy'])->name('test-item-normal-ranges.import-session-destroy');
   });

   /******************************** test-units **************************************/
   Route::resource('test-units', TestUnitsController::class);
   Route::prefix('/test-units/')->group(function () {
      Route::any('/delete', [TestUnitsController::class, 'destroy'])->name('test-units.destroy');
      Route::any('/change-status', [TestUnitsController::class, 'changeStatus'])->name('test-units.changestatus');

      // IMPORT/EXPORT
      Route::any('/import/create', [TestUnitsController::class, 'importCreate'])->name('test-units.import-create');
      Route::any('/import/preview', [TestUnitsController::class, 'importPreview'])->name('test-units.import-preview');
      Route::any('/store/import', [TestUnitsController::class, 'importStore'])->name('test-units.import-store');
      Route::any('/export/format', [TestUnitsController::class, 'exportFormat'])->name('test-units.export-format');
      Route::any('/import/session/delete', [TestUnitsController::class, 'ImportSessionDestroy'])->name('test-units.import-session-destroy');
   });

   /********************************** Test-methods *********************************/
   Route::resource('test-methods', TestMethodsController::class);
   Route::prefix('/test-methods/')->group(function () {
      Route::any('/delete', [TestMethodsController::class, 'destroy'])->name('test-methods.destroy');
      Route::any('/change-status', [TestMethodsController::class, 'changeStatus'])->name('test-methods.changestatus');
      Route::any('/show-report', [TestMethodsController::class, 'showReport'])->name('test-methods.showreport');

      // IMPORT/EXPORT
      Route::any('/import/create', [TestMethodsController::class, 'importCreate'])->name('test-methods.import-create');
      Route::any('/import/preview', [TestMethodsController::class, 'importPreview'])->name('test-methods.import-preview');
      Route::any('/store/import', [TestMethodsController::class, 'importStore'])->name('test-methods.import-store');
      Route::any('/export/format', [TestMethodsController::class, 'exportFormat'])->name('test-methods.export-format');
      Route::any('/import/session/delete', [TestMethodsController::class, 'importSessionDestroy'])->name('test-methods.import-session-destroy');
   });

   /********************************** Departments ***********************************/
   Route::resource('departments', DepartmentsController::class);
   Route::prefix('/departments/')->group(function () {
      Route::any('/delete', [DepartmentsController::class, 'destroy'])->name('departments.destroy');
      Route::any('/pagebreak-status', [DepartmentsController::class, 'pagebreakstatus'])->name('departments.pagebreakstatus');
      Route::any('/show-report', [DepartmentsController::class, 'showReport'])->name('departments.showreport');
      Route::any('/change-status', [DepartmentsController::class, 'changeStatus'])->name('departments.changestatus');
      Route::any('/change-heading', [DepartmentsController::class, 'reportHeading'])->name('departments.reportHeading');

      // IMPORT/EXPORT
      Route::any('/import/create', [DepartmentsController::class, 'importCreate'])->name('departments.import-create');
      Route::any('/import/preview', [DepartmentsController::class, 'importPreview'])->name('departments.import-preview');
      Route::any('/store/import', [DepartmentsController::class, 'importStore'])->name('departments.import-store');
      Route::any('/export/format', [DepartmentsController::class, 'exportFormat'])->name('departments.export-format');
      Route::any('/import/session/delete', [DepartmentsController::class, 'importSessionDestroy'])->name('departments.import-session-destroy');
   });

   Route::get('/departments-permission', [DepartmentsController::class, 'permission'])->name('departments.permission');
   Route::get('/departments-permission/{id}/edit', [DepartmentsController::class, 'permissionEdit'])->name('departments.permission-edit');
   Route::post('/departments-permission/{id}/update', [DepartmentsController::class, 'permissionUpdate'])->name('departments.permission-update');

   /********************************** Sample-types ***************************************/
   Route::resource('sample-types', SampleTypesController::class);
   Route::prefix('/sample-types/')->group(function () {
      Route::any('/delete', [SampleTypesController::class, 'destroy'])->name('sample-types.destroy');
      Route::any('/change-status', [SampleTypesController::class, 'changeStatus'])->name('sample-types.changestatus');

      // IMPORT/EXPORT
      Route::any('/import/create', [SampleTypesController::class, 'importCreate'])->name('sample-types.import-create');
      Route::any('/import/preview', [SampleTypesController::class, 'importPreview'])->name('sample-types.import-preview');
      Route::any('/store/import', [SampleTypesController::class, 'importStore'])->name('sample-types.import-store');
      Route::any('/export/format', [SampleTypesController::class, 'exportFormat'])->name('sample-types.export-format');
      Route::any('/import/session/delete', [SampleTypesController::class, 'importSessionDestroy'])->name('sample-types.import-session-destroy');
   });

   /********************************** Style-types ************************************/
   Route::resource('style-types', StyleTypesController::class);
   Route::prefix('/style-types/')->group(function () {
      Route::any('/delete', [StyleTypesController::class, 'destroy'])->name('style-types.destroy');
      Route::any('/change-status', [StyleTypesController::class, 'changeStatus'])->name('style-types.changestatus');
      Route::any('/change-isdefault', [StyleTypesController::class, 'isDefault'])->name('style-types.isdefault');
   });

   /************************* Sample-Collection-Tubes *********************************/
   Route::resource('sample-collection-tubes', SampleCollectionTubesController::class);
   Route::prefix('/sample-collection-tubes/')->group(function () {
      Route::any('/delete', [SampleCollectionTubesController::class, 'destroy'])->name('sample-collection-tubes.destroy');
      Route::any('/change-status', [SampleCollectionTubesController::class, 'changeStatus'])->name('sample-collection-tubes.changestatus');
   });

   /*************************** Special-Cases **************************************/
   Route::resource('special-cases', SpecialCasesController::class);
   Route::prefix('/special-cases/')->group(function () {
      Route::any('/delete', [SpecialCasesController::class, 'destroy'])->name('special-cases.destroy');
      Route::any('/change-status', [SpecialCasesController::class, 'changeStatus'])->name('special-cases.changestatus');
      Route::any('/change-isdefault', [SpecialCasesController::class, 'isDefault'])->name('special-cases.isdefault');
   });

   /***************************** Machine-And-Equipments *********************************/
   Route::resource('machine-and-equipments', MachineAndEquipmentsController::class);
   Route::prefix('/machine-and-equipments/')->group(function () {
      Route::any('/delete', [MachineAndEquipmentsController::class, 'destroy'])->name('machine-and-equipments.destroy');
      Route::any('/change-status', [MachineAndEquipmentsController::class, 'changeStatus'])->name('machine-and-equipments.changestatus');
      Route::any('/show/{id?}', [MachineAndEquipmentsController::class, 'show'])->name('machine-and-equipments.show');
   });

   /*************************** Signatures **************************************/
   Route::resource('signatures', SignaturesController::class);
   Route::prefix('/signatures/')->group(function () {
      Route::any('/delete', [SignaturesController::class, 'destroy'])->name('signatures.destroy');
      Route::any('/change-status', [SignaturesController::class, 'changeStatus'])->name('signatures.changestatus');
      Route::any('/change-isdefault', [SignaturesController::class, 'isDefault'])->name('signatures.isdefault');
   });
   Route::get('/signatures-permission', [SignaturesController::class, 'permission'])->name('signatures.permission');
   Route::get('/signatures-permission/{id}/edit', [SignaturesController::class, 'permissionEdit'])->name('signatures.permission-edit');
   Route::post('/signatures-permission/{id}/update', [SignaturesController::class, 'permissionUpdate'])->name('signatures.permission-update');

    /******************************** Test Item Templete **************************************/
    Route::prefix('/test-item-templates/')->group(function () {
        Route::any('/{id?}/index', [TestItemTemplateController::class, 'index'])->name('test-item-templates.index');
        Route::any('/create/{id?}', [TestItemTemplateController::class, 'create'])->name('test-item-templates.create');
        Route::any('/{id?}/store', [TestItemTemplateController::class, 'store'])->name('test-item-templates.store');
        Route::any('/{id?}/edit', [TestItemTemplateController::class, 'edit'])->name('test-item-templates.edit');
        Route::any('/{id?}/update', [TestItemTemplateController::class, 'update'])->name('test-item-templates.update');
        Route::any('/delete', [TestItemTemplateController::class, 'destroy'])->name('test-item-templates.destroy');
        Route::any('/change-status', [TestItemTemplateController::class, 'changeStatus'])->name('test-item-templates.changestatus');
        Route::any('/change-default', [TestItemTemplateController::class, 'changeDefault'])->name('test-item-templates.changeDefault');
    });
