<?php

use App\Http\Controllers\VehicleRegister\VehicleRegisterController;
use Illuminate\Support\Facades\Route;
   /******************************* Vehicle Register*****************************/




/******************************* Main Route*****************************/
Route::resource('/vehicle-register', VehicleRegisterController::class);



//Create vehicle 
Route::get('vehicle-account-create', [VehicleRegisterController::class, 'createVehicle'])->name('vehicle-account-create');

Route::post('vehicle-account-store',[VehicleRegisterController::class, 'storeVehicle'])->name('vehicle-account-store');


/*******************************Create*****************************/
Route::get('driver-account-create', [VehicleRegisterController::class, 'createDriver'])->name('driver-account-create');
Route::get('vendor-account-create', [VehicleRegisterController::class, 'createVendor'])->name('vendor-account-create');


/*******************************Store*****************************/
Route::post('vendor-account-store', [VehicleRegisterController::class, 'storeVendor'])->name('vendor-account-store');
Route::post('driver-account-store', [VehicleRegisterController::class, 'storeDriver'])->name('driver-account-store');


/*******************************Search*****************************/
Route::any('register-search-driver', [VehicleRegisterController::class, 'searchDrivers'])->name('register-search-driver');
Route::any('register-search-vendor', [VehicleRegisterController::class, 'searchVendors'])->name('register-search-vendor');


/*******************************Edit*****************************/
Route::get('driver-account-edit/{id}', [VehicleRegisterController::class, 'EditDriver'])->name('driver-account-edit');
Route::get('vendor-account-edit/{id}', [VehicleRegisterController::class, 'EditVendor'])->name('vendor-account-edit');


/*******************************changestatus*****************************/
Route::post('/changeStatus', [VehicleRegisterController::class, 'changeStatus'])->name('vehicle-register-changestatus');


/*******************************Update Driver*****************************/
Route::post('/driver-update/{id}', [VehicleRegisterController::class, 'UpdateDriver'])->name('driver-account-update');
Route::post('/vendor-update/{id}', [VehicleRegisterController::class, 'UpdateVendor'])->name('vendor-account-update');






Route::get('vehicle-register-import/create', [VehicleRegisterController::class, 'importVehiclesForm'])->name('vehicle-register-import.create');

Route::post('vehicle-register-import/store', [VehicleRegisterController::class, 'importBulkVehicles'])->name('vehicle-register-import.store');

Route::get('vehicle-register-import/modal', [VehicleRegisterController::class, 'importForm'])->name('vehicle-register-import.modal');

Route::get('vehicle-register-import/edit/{id}', [VehicleRegisterController::class, 'editVehicles'])->name('vehicle-register-import.edit');

Route::post('vehicle-register/update/{id}', [VehicleRegisterController::class, 'updateVehicles'])->name('vehicle-register-import.update');

Route::post('vehicle-register-import/proceed', [VehicleRegisterController::class, 'importVehicles'])->name('vehicle-register-import.proceed');


Route::get('/vehicle-register-clear-data', [VehicleRegisterController::class, 'clearData'])->name('vehicle-register-import.clear-data');


Route::post('vehicle-register/delete', [VehicleRegisterController::class, 'importDestroy'])->name('vehicle-register.destroy');











	