<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Controller;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\SoftwareFeaturesController;
use App\Http\Controllers\UserLicenseController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BucketController;
use App\Http\Controllers\InvoiceSerialSettingController;
use App\Http\Controllers\Website\FrontController;
use App\Http\Controllers\PaymentModesController;
use App\Http\Controllers\ClientsController;
use App\Http\Controllers\PermissionsController;
use App\Http\Controllers\DocumentTypesController;
use App\Http\Controllers\DaysController;
use App\Http\Controllers\PriceSettingController;
use App\Http\Controllers\PrintStyleSettingsController;
use App\Http\Controllers\FilesManagerController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\Company\CompanyController;
use App\Http\Controllers\VoucherTrackStatusController;
use App\Http\Controllers\UserTypesController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/home', [HomeController::class, 'index'])->name('home');
Route::get('/patient-register', [RegisterController::class, 'registerPatient'])->name('register-patient');
Route::post('/patient-store-register', [RegisterController::class, 'registerPatientStore'])->name('register-patient-store');
Route::get('/registration', [RegisterController::class, 'clientRegister'])->name('client-register');
Route::post('/client-register-store', [RegisterController::class, 'clientRegisterStore'])->name('client-register-store');
Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('forget-password', [ForgotPasswordController::class, 'showForgetPasswordForm'])->name('forget.password.get');
Route::post('forget-password', [ForgotPasswordController::class, 'submitForgetPasswordForm'])->name('forget.password.post');
Route::get('reset-password/{token}', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('reset.password.get');
Route::post('reset-password', [ForgotPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');
Route::post('submit-user-financial-year', [UserController::class, 'submitUserFinancialYear'])->name('submit-user-financial-year');

Route::get('/client-license-register', [RegisterController::class, 'clientLicenseRegister'])->name('client-license-register');
Route::post('/client-license-register-store', [RegisterController::class, 'clientLicenseRegisterStore'])->name('client-license-register-store');


Route::post('companies/getstate', [CompanyController::class, 'getstate']);
Route::post('companies/getcity', [CompanyController::class, 'getcity']);
Route::post('companies/getcityConsignor', [CompanyController::class, 'getcityConsignor']);
Route::post('companies/getcountrycode', [CompanyController::class, 'getcountrycode']);

Route::group(['middleware' => ['auth']], function () {

    /****************** Web Settings Routes **************************/
    require __DIR__.'/website_setting_routes.php';

    /****************** Billing Collection Routes **************************/
    require __DIR__.'/bill_collection_routes.php';

    /******************Library Routes **************************/
    require __DIR__.'/library_setting_routes.php';

    /****************** Accounts Routes **************************/
    require __DIR__.'/account_routes.php';

    /****************** Accounting Routes **************************/
    require __DIR__.'/accounting_routes.php';

    /****************** Academic Routes **************************/
    require __DIR__.'/academics.php';

    /****************** Students Manager Routes **************************/
    require __DIR__.'/students_manager_routes.php';

    /****************** Enquiry Routes **************************/
    require __DIR__.'/enquiry_routes.php';

    /****************** Tax Master Routes **************************/
    require __DIR__.'/tax_master_routes.php';

    /****************** Product Routes **************************/
    require __DIR__.'/product_routes.php';

    /****************** Test manager Routes **************************/
    require __DIR__.'/test_manager.php';

    /****************** Medical Setting Routes **************************/
    require __DIR__.'/medical_setting_routes.php';

    /****************** Company Routes **************************/
    require __DIR__.'/company_routes.php';


    /****************** Settings Routes **************************/
    require __DIR__.'/setting_routes.php';

    /****************** Workplace Routes **************************/
    require __DIR__.'/workplace.php';

    /****************** Workplace Routes **************************/
    require __DIR__.'/human_resource_routes.php';

    /****************** API Management Routes **************************/
    require __DIR__.'/api_management_routes.php';

    /****************** API Management Routes **************************/
    require __DIR__.'/marketing_routes.php';

    /****************** License Management Routes **************************/
    require __DIR__.'/license_management_routes.php';

    /****************** OPD Appointment Routes **************************/
    require __DIR__.'/opd_appointment_routes.php';

    /****************** IPD Admission Routes **************************/
    require __DIR__.'/ipd_admission_routes.php';

    /****************** Lab Billings Routes **************************/
    require __DIR__.'/lab_billing_pathology_routes.php';

    /****************** Lab Billings Routes **************************/
    require __DIR__.'/incentive_slabs.php';

    /****************** Doc management Routes **************************/
    require __DIR__.'/document_management_routes.php';

    /****************** Lab Reporting Routes **************************/
    require __DIR__.'/lab_reporting_routes.php';

    /****************** Queue Manager Routes **************************/
   require __DIR__.'/queue_manager_routes.php';

   /****************** sale route *****************/
   require __DIR__.'/sale_routes.php';

   /****************** Sales Return  Routes **************************/
     require __DIR__.'/sale_returns_routes.php';
   /****************** Purchase  Routes **************************/
   require __DIR__.'/purchase_routes.php';

    /****************** Stocks  Routes **************************/
    require __DIR__.'/stocks_routes.php';

     /****************** Vehicle  Register **************************/
    require __DIR__.'/vehicle_register/vehicle_register_routes.php';


    /****************** Vehicle Types **************************/
    require __DIR__.'/vehicle_types/vehicle_types_routes.php';


     /****************** Referral voucher routes **************************/
    require __DIR__.'/referral_vouchers_routes.php';

     /****************** Surgery Types routes **************************/
    require __DIR__.'/surgery_types/surgery_types_routes.php'; 


      /****************** Surgeries routes **************************/
    require __DIR__.'/surgeries/surgeries_routes.php';


      /****************** Surgeries routes **************************/
    require __DIR__.'/birth_registers/birth_registers_routes.php';


   /****************** Surgeries routes **************************/
    require __DIR__.'/death_registers/death_registers_routes.php';


   /****************** Abdm Api routes **************************/
    require __DIR__.'/abdm_api/abdm_api_routes.php';


    /****************** Abdm Api Calls routes **************************/
    require __DIR__.'/abdm_api_calls/abdm_api_calls_routes.php';

    /****************** Letter Heads routes **************************/
    require __DIR__.'/letter_heads/letter_heads_routes.php';

    /****************** Task Manager routes **************************/
    require __DIR__.'/task_manager/task-manager.php';

    /****************** Study Materials **************************/
    require __DIR__.'/study_materials/study_materials_routes.php';

     /****************** Study Material Types **************************/
    require __DIR__.'/study_material_types/study_material_types_routes.php';

    /****************** Semesters **************************/
    require __DIR__.'/semesters/semesters_routes.php';

       /****************** Booking  Routes **************************/
    require __DIR__.'/booking_routes.php';

    /****************** Vehicle  Register **************************/
    require __DIR__.'/vehicle_register/vehicle_register_routes.php';


    /****************** Vehicle Types **************************/
    require __DIR__.'/vehicle_types/vehicle_types_routes.php';

      /****************** Vehicle Types **************************/
    require __DIR__.'/vehicle_document_types/vehicle_document_types_routes.php';


     /****************** Vehicle Document Validity **************************/
    require __DIR__.'/vehicle_documents_validity/vehicle_document_validity_routes.php';

   Route::any('bucket_file_download', [Controller::class, 'download'])->name('bucket_file_download');

   /**************************** User Route *********************************/
   Route::resource('users', UserController::class);
   Route::group(['prefix' => 'users'], function () {
      Route::get('/list', [UserController::class, 'list']);
      Route::any('/delete', [UserController::class, 'destroy'])->name('users.destroy');
      Route::any('/changestatus', [UserController::class, 'changestatus'])->name('users.changestatus');
      Route::post('user-search-accounts', [UserController::class, 'searchAccounts'])->name('users-search-accounts');
   });

   Route::post('/users/change-user-type', [UserController::class, 'changeUserType'])->name('users.change-user-type');


// USER TYPES 
   Route::resource('user-types', UserTypesController::class);
   Route::group(['prefix' => 'user-types'], function () {
      Route::get('/list', [UserTypesController::class, 'list']);

      Route::post('user-types-search-accounts', [UserTypesController::class, 'searchAccounts'])->name('user-types-search-accounts');
   });      
   Route::any('/delete/{id?}', [UserTypesController::class, 'destroy'])->name('user-types-destroy');
   Route::any('/changestatus', [UserTypesController::class, 'changestatus'])->name('user-types-changestatus');
   Route::any('user-types/create', [UserTypesController::class, 'create'])->name('user-types-create');






   Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
   Route::get('/signOut', [AdminController::class, 'signOut'])->name('signOut');

   /*******************************database migrate****************/
   Route::get('/run-migrations', function () {
      Artisan::call('migrate', ["--force" => true]);
      return redirect()->back()->with('success', 'Migrate successfully');
   });

   /******************************* Bucket Routes *************************************/
   Route::resource('buckets', BucketController::class);
   Route::group(['prefix' => 'buckets'], function () {
      Route::any('/changestatus', [BucketController::class, 'changestatus'])->name('buckets.changestatus');
      Route::any('/delete', [BucketController::class, 'delete'])->name('buckets.destroy');
   });
   // Route::get('buckets',[BucketController::class,'index']);
   // Route::match(['GET','POST'],'buckets/update/{id}',[BucketController::class,'update'])->name('bucket.update');

   /********************************** Invoice Settings *********************************************/
   Route::resource('invoice-setting', InvoiceSerialSettingController::class);
   Route::group(['prefix' => 'invoice-setting'], function () {
      Route::match(['GET', 'POST'], '/deletes', [InvoiceSerialSettingController::class, 'delete'])->name('invoice-setting.delete');
   });

   /********************************** Payment modes *********************************************/
   Route::resource('payment-modes', PaymentModesController::class);
   Route::group(['prefix' => 'payment-modes'], function () {
      Route::get('/list', [PaymentModesController::class, 'list']);
      Route::any('/delete', [PaymentModesController::class, 'destroy'])->name('payment-modes.destroy');
      Route::any('/changestatus', [PaymentModesController::class, 'changeStatus'])->name('payment-modes.changestatus');
      Route::any('/changedefault', [PaymentModesController::class, 'changedefault'])->name('payment-modes.changedefault');
   });
   /********************************** Permissions *********************************************/
   Route::resource('permissions', PermissionsController::class);
   Route::any('module-permissions/{module}', [PermissionsController::class, 'index'])->name('module-permissions');
   Route::any('permissions/delete', [PermissionsController::class, 'destroy'])->name('permissions.destroy');

   /**************************** Document type *********************************/
   Route::resource('document-types', DocumentTypesController::class);
   Route::group(['prefix' => 'document-types'], function () {
      Route::any('/changestatus', [DocumentTypesController::class, 'changestatus'])->name('document-types.changestatus');
      Route::match(['GET', 'POST'], '/delete', [DocumentTypesController::class, 'delete'])->name('document-types.destroy');
   });

    /********************** Price Setting ****************************/
    Route::resource('price-settings', PriceSettingController::class);
    Route::prefix('/price-settings/')->group(function () {
        Route::any('/delete',[PriceSettingController::class,'destroy'])->name('price-settings.destroy');
    });

   /**********************************  Print Style Settings  ************************************/
   Route::resource('print-style-settings', PrintStyleSettingsController::class);

    /************************** Files Manager *******************************/
    Route::resource('file-manager', FilesManagerController::class);
    Route::group(['prefix' => 'file-manager'], function () {
       Route::any('/delete', [FilesManagerController::class, 'destroy'])->name('file-manager.destroy');
       Route::any('/changeStatus', [FilesManagerController::class, 'changeStatus'])->name('file-manager.changestatus');
    });

    /**************************** Voucher Track Status Route *********************************/
    Route::resource('voucher-track-status', VoucherTrackStatusController::class);
    Route::group(['prefix' => 'voucher-track-status'], function () {
       Route::get('/list', [VoucherTrackStatusController::class, 'list']);
       Route::any('/delete', [VoucherTrackStatusController::class, 'destroy'])->name('voucher-track-status.destroy');
       Route::any('/changestatus', [VoucherTrackStatusController::class, 'changeStatus'])->name('voucher-track-status.changestatus');
    });

   Route::resource('sale', SalesController::class);
   Route::any('sale/delete', [SalesController::class, 'destroy'])->name('sale.destroy');
   //customer
   Route::get('customer-account-create', [SalesController::class, 'customerCreate'])->name('customer-account-create');
   Route::post('customer-account-store', [SalesController::class, 'storeCustomer'])->name('customer-account-store');
   Route::get('customer-account-edit/{id}', [SalesController::class, 'customerEdit'])->name('customer-account-edit');
   Route::post('customer-account-update/{id}', [SalesController::class, 'updateCustomer'])->name('customer-account-update');
   //search product & account
   Route::post('customer-account-search', [SalesController::class, 'searchCustomer'])->name('customer-account-search');
   Route::post('customer-search-products', [SalesController::class, 'searchProducts'])->name('customer-search-products');

   Route::post('/get-batch-information', [SalesController::class,'getBatchInformation'])->name('get-batch-information');
   Route::any('sale-cart-product-remove', [SalesController::class, 'cartProductRemove'])->name('sale-cart-product-remove');
   Route::get('sale-cart-billing', [SalesController::class, 'billing'])->name('sale-cart-billing');
   Route::any('sale-product-add-to-cart', [SalesController::class, 'productAddToCart'])->name('sale-product-add-to-cart');
   Route::any('sale-product-cart/{invoice_id?}', [SalesController::class, 'productCart'])->name('sale-product-cart');
   Route::any('sale-cart-product-update', [SalesController::class, 'cartProductUpdate'])->name('sale-cart-product-update');
    //invoice
   Route::get('sale-invoice/{id}', [SalesController::class, 'saleInvoice'])->name('sale-invoice');
   Route::get('sale-edit-cart-billing/{invoice_id}', [SalesController::class, 'SaleeditBilling'])->name('sale-edit-cart-billing');
    //collect
   Route::get('sale-collection/{invoice_id}', [SalesController::class, 'saleCollection'])->name('sale-collection');
   Route::post('update-sale-vouchers/{id}', [SalesController::class, 'saleCollectionUpdate'])->name('update-sale-vouchers');
   Route::get('/get-payment-modes', [SalesController::class, 'getPaymentModes'])->name('getPaymentModes');
   //sale statement
   Route::get('sale-statement', [SalesController::class, 'saleStatement'])->name('sale-statement');
   Route::get('sale-statement-export', [SalesController::class, 'saleStatementExport'])->name('sale-statement-export');

   //Bill To
   Route::get('get-bill-to', [SalesController::class, 'getBillTo'])->name('getBillTo');

    /**************************** Voucher Track Status Route *********************************/
    Route::resource('voucher-track-status', VoucherTrackStatusController::class);
    Route::group(['prefix' => 'voucher-track-status'], function () {
       Route::get('/list', [VoucherTrackStatusController::class, 'list']);
       Route::any('/delete', [VoucherTrackStatusController::class, 'destroy'])->name('voucher-track-status.destroy');
       Route::any('/changestatus', [VoucherTrackStatusController::class, 'changeStatus'])->name('voucher-track-status.changestatus');
    });
    
});
