<?php

use App\Http\Controllers\Website\BlogsController;
use App\Http\Controllers\Website\BranchesController;
use App\Http\Controllers\Website\BrandsLogoController;
use App\Http\Controllers\Website\ClientSayController;
use App\Http\Controllers\Website\ContactEnquiryController;
use App\Http\Controllers\Website\ContentSubCategoryController;
use App\Http\Controllers\Website\FaqController;
use App\Http\Controllers\Website\HomeCollectionController;
use App\Http\Controllers\Website\NewsLetterController;
use App\Http\Controllers\Website\PhotoGalleryController;
use App\Http\Controllers\Website\PlanController;
use App\Http\Controllers\Website\PostController;
use App\Http\Controllers\Website\ProjectAmenitiesController;
use App\Http\Controllers\Website\ProjectConnectivityController;
use App\Http\Controllers\Website\ProjectController;
use App\Http\Controllers\Website\ProjectDeveloperController;
use App\Http\Controllers\Website\ProjectLocationController;
use App\Http\Controllers\Website\ProjectOverviewController;
use App\Http\Controllers\Website\ProjectVideosController;
use App\Http\Controllers\Website\ProjectWhyusController;
use App\Http\Controllers\Website\PublicContentCategoryController;
use App\Http\Controllers\Website\PublicContentController;
use App\Http\Controllers\Website\ServicesController;
use App\Http\Controllers\Website\SettingController;
use App\Http\Controllers\Website\SliderController;
use App\Http\Controllers\Website\SocialMediaController;
use App\Http\Controllers\Website\TeamController;
use App\Http\Controllers\Website\VideoGalleryController;
use App\Http\Controllers\Website\NoticesController;
use App\Http\Controllers\Website\CareerVacancyController;
use App\Http\Controllers\Website\JobApplicationController;
use Illuminate\Support\Facades\Route;


      /******************************Website Backend Route Slider *************************/
      Route::resource('sliders', SliderController::class);
      Route::group(['prefix'=>'sliders'],function()
      {
      Route::any('/changestatus',[SliderController::class,'changestatus'])->name('sliders.changestatus');
      Route::any('/delete',[SliderController::class,'delete'])->name('sliders.delete');
      });
      /******************************Public Content Category *************************/
   Route::resource('content-category', PublicContentCategoryController::class);
   Route::group(['prefix'=>'content-category'],function()
   {
   Route::any('/changestatus',[PublicContentCategoryController::class,'changestatus'])->name('content-category.changestatus');
   Route::any('/delete',[PublicContentCategoryController::class,'delete'])->name('content-category.delete');
   });

     /******************************Public Content Sub Category *************************/
     Route::resource('content-sub-category', ContentSubCategoryController::class);
     Route::group(['prefix'=>'content-sub-category'],function(){
      Route::any('content-sub-category/index1',[ContentSubCategoryController::class,'indexNew'])->name('content-sub-category.index1');
      Route::any('/changestatus',[ContentSubCategoryController::class,'changestatus'])->name('content-sub-category.changestatus');
      Route::any('/delete',[ContentSubCategoryController::class,'delete'])->name('content-sub-category.delete');
     });

    /******************************Public Content *************************/
   Route::resource('public-content', PublicContentController::class);
   Route::group(['prefix'=>'public-content'],function()
   {
    Route::any('public-content/index1',[PublicContentController::class,'indexNew'])->name('public-content.index1');
    Route::any('/changestatus',[PublicContentController::class,'changestatus'])->name('public-content.changestatus');
    Route::any('/delete',[PublicContentController::class,'delete'])->name('public-content.delete');
    Route::any('public-content/get-subcategory',[PublicContentController::class,'getSubCategory'])->name('public-content.sub-category');
   });


   /******************************Photos Gallery Route *************************/
   Route::resource('photos-gallery', PhotoGalleryController::class);
   Route::group(['prefix'=>'photos-gallery'],function()
   {
      Route::match(['GET','POST'],'/store-item',[PhotoGalleryController::class,'storeitem'])->name('photos-gallery.store-item');
      Route::any('/changestatus',[PhotoGalleryController::class,'changestatus'])->name('photos-gallery.changestatus');
      Route::any('/delete',[PhotoGalleryController::class,'delete'])->name('photos-gallery.delete');
      Route::match(['GET','POST'],'/delete-item',[PhotoGalleryController::class,'deleteitem'])->name('photos-gallery.deleteitem');
   });


   /******************************Video Gallery Route *************************/
   Route::resource('videos-gallery', VideoGalleryController::class);
   Route::group(['prefix'=>'videos-gallery'],function()
   {
      Route::any('/changestatus',[VideoGalleryController::class,'changestatus'])->name('videos-gallery.changestatus');
      Route::any('/delete',[VideoGalleryController::class,'delete'])->name('videos-gallery.delete');
   });


   /******************************Page Settting Route *************************/
   Route::resource('pages-setting', PostController::class);
   Route::group(['prefix'=>'pages-setting'],function()
   {
      Route::any('/changestatus',[PostController::class,'changestatus'])->name('pages-setting.changestatus');
      Route::any('/delete',[PostController::class,'delete'])->name('pages-setting.delete');
      Route::any('/page-content-data/{id}',[PostController::class,'pageContent'])->name('pages-setting.page-content');
      Route::any('/page-content-data/create/{id}',[PostController::class,'pageContentCreate'])->name('page-content.create');
      Route::any('pages-setting/page-content-data/getPage/',[PostController::class,'pageContentGet'])->name('page-content.getPage.content');
      
   });
   Route::any('/page-content-data/store',[PostController::class,'pageContentStore'])->name('page-content.getPage.content.store');
   Route::any('/page-content-data/edit/{id}',[PostController::class,'pageContentEdit'])->name('page-content.getPage.content.edit');
   Route::any('/page-content-data/update{id}',[PostController::class,'pageContentUpdate'])->name('page-content.getPage.content.update');

   Route::any('page-content-data/changestatus',[PostController::class,'pageContentChangeStatus'])->name('page-content.getPage.content.changestatus');
   Route::any('page-content-data/delete/{id}',[PostController::class,'pageContentDelete'])->name('page-content.getPage.content.delete');
   /******************************Setting List Route *************************/
   Route::resource('settings', SettingController::class);
   Route::group(['prefix'=>'settings'],function()
   {
     Route::any('/changestatus',[SettingController::class,'changestatus'])->name('settings.changestatus');
     Route::any('/delete',[SettingController::class,'delete'])->name('settings.delete');
   });

   /******************************Contact Enquiry List Route *************************/
   Route::resource('contact-enquiry', ContactEnquiryController::class);
   Route::group(['prefix'=>'contact-enquiry'],function()
   {
     Route::any('/delete',[ContactEnquiryController::class,'delete'])->name('contact-enquiry.delete');
   });

   /******************************Social Media List Route *************************/
   Route::resource('social-media', SocialMediaController::class);
   Route::group(['prefix'=>'social-media'],function()
   {
     Route::any('/changestatus',[SocialMediaController::class,'changestatus'])->name('social-media.changestatus');
     Route::any('/delete',[SocialMediaController::class,'delete'])->name('social-media.delete');
   });


    /******************************Faq List Route *************************/
    Route::resource('faqs', FaqController::class);
    Route::group(['prefix'=>'faqs'],function()
    {
      Route::any('/changestatus',[FaqController::class,'changestatus'])->name('faqs.changestatus');
      Route::any('/delete',[FaqController::class,'delete'])->name('faqs.delete');
    });

    /******************************Services List Route *************************/
    Route::resource('services', ServicesController::class);
    Route::group(['prefix'=>'services'],function()
    {
      Route::any('/changestatus',[ServicesController::class,'changestatus'])->name('services.changestatus');
      Route::match(['GET','POST'],'/delete',[ServicesController::class,'delete'])->name('services.delete');
    });
    /******************************Blog List Route *************************/
    Route::resource('blogs', BlogsController::class);
    Route::group(['prefix'=>'blogs'],function()
    {
      Route::any('/changestatus',[BlogsController::class,'changestatus'])->name('blogs.changestatus');
      Route::match(['GET','POST'],'/delete',[BlogsController::class,'delete'])->name('blogs.delete');
    });

    /******************************Client Say List Route *************************/
    Route::resource('testimonials', ClientSayController::class);
    Route::group(['prefix'=>'testimonials'],function()
    {
      Route::any('/changestatus',[ClientSayController::class,'changestatus'])->name('testimonials.changestatus');
      Route::match(['GET','POST'],'/delete',[ClientSayController::class,'delete'])->name('testimonials.delete');
    });

     /****************************** Home Collectionn List Route *************************/

     Route::group(['prefix'=>'visit-request'],function()
     {
      Route::resource('home-collections', HomeCollectionController::class);
       Route::any('/changestatus',[HomeCollectionController::class,'changestatus'])->name('home-collections.changestatus');
       Route::match(['GET','POST'],'/delete',[HomeCollectionController::class,'delete'])->name('home-collections.delete');
       Route::any('/update-status/{id}',[HomeCollectionController::class,'updateCollectionStatus'])->name('home-collections-status.update');
       Route::any('/visit-request/home-collections/export-visit-request',[HomeCollectionController::class,'exportRequest'])->name('export-visit-request');
     });


     /****************************** Package & Plans List Route *************************/
     Route::resource('package-plans', PlanController::class);
     Route::group(['prefix'=>'package-plans'],function()
     {
       Route::any('/changestatus',[PlanController::class,'changestatus'])->name('package-plans.changestatus');
       Route::match(['GET','POST'],'/delete',[PlanController::class,'delete'])->name('package-plans.delete');
     });

     /****************************** Teams List Route *************************/
     Route::resource('teams', TeamController::class);
     Route::group(['prefix'=>'teams'],function()
     {
       Route::any('/changestatus',[TeamController::class,'changestatus'])->name('teams.changestatus');
       Route::match(['GET','POST'],'/delete',[TeamController::class,'delete'])->name('teams.delete');
     });

     /****************************** Notice Route *************************/
     Route::resource('notices', NoticesController::class);
     Route::group(['prefix'=>'notices'], function() {
       Route::any('/delete',[NoticesController::class,'destroy'])->name('notice.delete');
       Route::any('/changestatus',[NoticesController::class,'changestatus'])->name('notices.changestatus');
       Route::any('/change-new-status',[NoticesController::class,'changeFlagStatus'])->name('notices.changeFlagStatus');
     });

     /****************************** Branches Route *************************/
     Route::resource('branches', BranchesController::class);
     Route::group(['prefix'=>'branches'], function() {
       Route::any('/delete',[BranchesController::class,'delete'])->name('branches.delete');
       Route::any('/changestatus',[BranchesController::class,'changestatus'])->name('branches.changestatus');
     });

    /****************************** Brands Route *************************/
    Route::resource('brands-logo', BrandsLogoController::class);
    Route::group(['prefix'=>'brands-logo'], function() {
      Route::any('/delete',[BrandsLogoController::class,'delete'])->name('brands-logo.delete');
      Route::any('/changestatus',[BrandsLogoController::class,'changestatus'])->name('brands-logo.changestatus');
    });
    Route::resource('news-letter', NewsLetterController::class);
    Route::group(['prefix'=>'news-letter'], function() {
      Route::any('/delete',[NewsLetterController::class,'delete'])->name('news-letter.delete');
      Route::any('/changestatus',[NewsLetterController::class,'changestatus'])->name('news-letter.changestatus');
    });

    /******************************  Career Vacancies *************************/
    Route::resource('career-vacancy', CareerVacancyController::class);
    Route::group(['prefix'=>'career-vacancy'], function() {
      Route::any('/delete',[CareerVacancyController::class,'destroy'])->name('career-vacancy.delete');
      Route::any('/changestatus',[CareerVacancyController::class,'changestatus'])->name('career-vacancy.changestatus');
    });

    /******************************  Job Application  *************************/
    Route::resource('job-application', JobApplicationController::class);
    Route::group(['prefix'=>'job-application'], function() {
      Route::any('/delete',[JobApplicationController::class,'destroy'])->name('job-application.delete');
    });

?>
