<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Workplace\BudgetTypesController;
use App\Http\Controllers\Workplace\ProjectsController;
use App\Http\Controllers\Workplace\ProjectTypesController;
use App\Http\Controllers\Workplace\ProjectAttachmentsController;
use App\Http\Controllers\Workplace\ProjectBudgetsController;
use App\Http\Controllers\Workplace\ProjectRequirementsController;
use App\Http\Controllers\Workplace\ProjectTeamsController;
use App\Http\Controllers\Workplace\TaskChargesController;
use App\Http\Controllers\Workplace\TaskAttachmentsController;
use App\Http\Controllers\Workplace\TaskPriorityController;
use App\Http\Controllers\Workplace\TaskStatusController;
use App\Http\Controllers\Workplace\TaskTypeController;
use App\Http\Controllers\Workplace\TaskEntriesController;
use App\Http\Controllers\Workplace\TasksController;
use App\Http\Controllers\Workplace\TaskTrackingsController;

     /**********************************  Project Types ************************************/
     Route::resource('project-types', ProjectTypesController::class);
     Route::prefix('/project-types/')->group(function () {
        Route::any('/delete', [ProjectTypesController::class, 'destroy'])->name('project-types.destroy');
        Route::any('/change-status', [ProjectTypesController::class, 'changeStatus'])->name('project-types.changestatus');
        Route::any('/changedefault', [ProjectTypesController::class, 'changedefault'])->name('project-types.changedefault');
     });
     /**********************************  Projects ************************************/
     Route::resource('projects', ProjectsController::class);
     Route::prefix('/projects/')->group(function () {
        Route::any('/delete', [ProjectsController::class, 'destroy'])->name('projects.destroy');
        Route::any('/change-status', [ProjectsController::class, 'changeStatus'])->name('projects.changestatus');
        Route::get('/project-buddget/{id}', [ProjectsController::class, 'projectBudget'])->name('project.budget');
        Route::get('/project-attachments/{id}', [ProjectsController::class, 'projectProjectAttachment'])->name('project.attachments');
        Route::get('/project-requirments/{id}', [ProjectsController::class, 'projectRequirment'])->name('project.requirments');
        Route::get('/project-teams/{id}', [ProjectsController::class, 'projectTeam'])->name('project.teams');
     });

     /**********************************  Budget Type ************************************/
     Route::resource('budget-types', BudgetTypesController::class);
     Route::prefix('/budget-types/')->group(function () {
        Route::any('/delete', [BudgetTypesController::class, 'destroy'])->name('budget-types.destroy');
        Route::any('/change-status', [BudgetTypesController::class, 'changeStatus'])->name('budget-types.changestatus');
     });
     /**********************************  Project Budget  ************************************/
     Route::resource('project-budget', ProjectBudgetsController::class);
     Route::prefix('/project-budget/')->group(function () {
        Route::any('/delete', [ProjectBudgetsController::class, 'destroy'])->name('project-budget.destroy');
        Route::any('/change-status', [ProjectBudgetsController::class, 'changeStatus'])->name('project-budget.changestatus');
     });

     /**********************************  Project Attachments  ************************************/
     Route::resource('project-attachments', ProjectAttachmentsController::class);
     Route::prefix('/project-attachments/')->group(function () {
        Route::any('/delete', [ProjectAttachmentsController::class, 'destroy'])->name('project-attachments.destroy');
        Route::any('/change-status', [ProjectAttachmentsController::class, 'changeStatus'])->name('project-attachments.changestatus');
     });
     /**********************************  Project requirements  ************************************/
     Route::resource('project-requirements', ProjectRequirementsController::class);
     Route::prefix('/project-requirements/')->group(function () {
        Route::any('/delete', [ProjectRequirementsController::class, 'destroy'])->name('project-requirements.destroy');
        Route::any('/change-status', [ProjectRequirementsController::class, 'changeStatus'])->name('project-requirements.changestatus');
     });
     /**********************************  Task Type  ************************************/
     Route::resource('task-types', TaskTypeController::class);
     Route::prefix('/task-types/')->group(function () {
        Route::any('/delete', [TaskTypeController::class, 'destroy'])->name('task-types.destroy');
        Route::any('/change-status', [TaskTypeController::class, 'changeStatus'])->name('task-types.changestatus');
    });

     /**********************************  Tasks  ************************************/
     Route::resource('task', TasksController::class);
     Route::prefix('/task/')->group(function () {
        Route::any('/delete', [TasksController::class, 'destroy'])->name('tasks.destroy');
        Route::any('/change-status', [TasksController::class, 'changeStatus'])->name('tasks.changestatus');
        Route::any('/change-isdefault', [TasksController::class, 'isDefault'])->name('tasks.isdefault');
        Route::get('/task-attachments/{id}', [TasksController::class, 'taskAttachment'])->name('task.attachments');
        Route::get('/task-entry/{id}', [TasksController::class, 'taskEntry'])->name('task.entry');
        Route::get('/task-tracking/{id}', [TasksController::class, 'taskTracking'])->name('task.tracking');
    });
    Route::post('task-search-accounts', [TasksController::class, 'searchAccounts'])->name('task-search-accounts');
    Route::get('/project-task/{id}', [TasksController::class, 'index'])->name('task.index');
    Route::post('/store-task-work-status/{id}', [TasksController::class, 'storeTaskStatus'])->name('store.task-work-status');
    Route::post('/store-task-priority/{id}', [TasksController::class, 'storeTaskPriority'])->name('store.task-priority');
    Route::post('/store-task-project/{id}', [TasksController::class, 'storeTaskProject'])->name('store.task-project');
    Route::post('/store-task-group/{id}', [TasksController::class, 'storeTaskGroup'])->name('store.task-group');
    Route::post('/store-task-type/{id}', [TasksController::class, 'storeTaskType'])->name('store.task-type');

     /**********************************  Project Teams  ************************************/
     Route::resource('project-teams', ProjectTeamsController::class);
     Route::prefix('/project-teams/')->group(function () {
        Route::any('/delete', [ProjectTeamsController::class, 'destroy'])->name('project-teams.destroy');
        Route::any('/change-status', [ProjectTeamsController::class, 'changeStatus'])->name('project-teams.changestatus');
        Route::any('/change-manager', [ProjectTeamsController::class, 'changeManager'])->name('project-teams.changeManger');
    });

    /**********************************  Task Attachments  ************************************/
     Route::resource('task-attachments', TaskAttachmentsController::class);
     Route::prefix('/task-attachments/')->group(function () {
        Route::any('/delete', [TaskAttachmentsController::class, 'destroy'])->name('task-attachments.destroy');
        Route::any('/change-status', [TaskAttachmentsController::class, 'changeStatus'])->name('task-attachments.changestatus');
    });
     /************************** Task Status  *******************************/
   Route::resource('task-status', TaskStatusController::class);
   Route::group(['prefix' => 'task-status'], function () {
      Route::any('/delete', [TaskStatusController::class, 'destroy'])->name('task-status.destroy');
      Route::any('/changeStatus', [TaskStatusController::class, 'changeStatus'])->name('task-status.changestatus');
      Route::any('/changedefault', [TaskStatusController::class, 'changedefault'])->name('task-status.changedefault');
   });
     /************************** Task priority  *******************************/
   Route::resource('task-priority', TaskPriorityController::class);
   Route::group(['prefix' => 'task-priority'], function () {
      Route::any('/delete', [TaskPriorityController::class, 'destroy'])->name('task-priority.destroy');
      Route::any('/changeStatus', [TaskPriorityController::class, 'changeStatus'])->name('task-priority.changestatus');
   });
     /************************** Task entry  *******************************/
   Route::resource('task-entry', TaskEntriesController::class);
   Route::group(['prefix' => 'task-entry'], function () {
      Route::any('/delete', [TaskEntriesController::class, 'destroy'])->name('task-entry.destroy');
      Route::any('/changeStatus', [TaskEntriesController::class, 'changeStatus'])->name('task-entry.changestatus');
      Route::any('/team-approval', [TaskEntriesController::class, 'teamApproval'])->name('task-entry.team-approval');
   });
   /************************** Task Charges  *******************************/
   Route::resource('task-charges', TaskChargesController::class);
   Route::group(['prefix' => 'task-charges'], function () {
      Route::any('/delete', [TaskChargesController::class, 'destroy'])->name('task-charges.destroy');
      Route::any('/changeStatus', [TaskChargesController::class, 'changeStatus'])->name('task-charges.changestatus');
      Route::any('/changedefault', [TaskChargesController::class, 'changedefault'])->name('task-charges.changedefault');
   });

    /************************** Task tracking  *******************************/
    Route::resource('task-tracking', TaskTrackingsController::class);
    Route::group(['prefix' => 'task-tracking'], function () {
       Route::any('/delete', [TaskTrackingsController::class, 'destroy'])->name('task-tracking.destroy');
       Route::any('/changeStatus', [TaskTrackingsController::class, 'changeStatus'])->name('task-tracking.changestatus');
    });