<?php
    if (session()->has('company_data')) {
        $companyData = session('company_data');
    } else {
        $companyData = getComapnyName(); // Assuming getComapnyName() is a helper function or method
    }
?>
<!DOCTYPE html>
<html lang="en" class="semi-dark">

    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!--Less-->
        <link rel="stylesheet/less" type="text/css" href="<?php echo e(asset('admin/plugins/datepicker/less/datepicker.less')); ?>">
        <!--plugins-->
        <link href="<?php echo e(asset('admin/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/plugins/select2/css/select2-bootstrap4.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/plugins/datetimepicker/css/classic.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/plugins/datepicker/css/datepicker.css')); ?>" rel="stylesheet" />
        <!-- Bootstrap CSS -->
        <link href="<?php echo e(asset('admin/css/bootstrap.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/css/bootstrap-extended.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('admin/css/icons.css')); ?>" rel="stylesheet">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css" rel="stylesheet">

        <!----print css-->

        <!-- Stylesheet CSS -->
        <link href="<?php echo e(asset('admin/css/style.css')); ?>" rel="stylesheet" />
        <!-- switcher -->
        <link href="<?php echo e(asset('admin/css/switcher.css')); ?>" rel="stylesheet" type="text/css">
        <!-- loader-->

        <!--Theme Styles-->
        <link href="<?php echo e(asset('admin/css/theme/semi-dark.css')); ?>" rel="stylesheet" />
        <!-- Favicon.io -->
        <link rel="icon" href="<?php echo e(asset('admin/images/favicon.ico')); ?>" type="image/png" />

        <script type="text/javascript" src="<?php echo e(asset('admin/js/jquery3.3.1.min.js')); ?>"></script>
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <link href="<?php echo e(asset('admin/css/toastr.min.css')); ?>" rel="stylesheet" type="text/css">
        <link href="<?php echo e(asset('admin/css/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">

        <script type="text/javascript" src="<?php echo e(asset('admin/js/parsley.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/js/toastr.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/js/sweetalert2.all.min.js')); ?>"></script>

        <link href="<?php echo e(asset('admin/css/jquery-ui.css')); ?>" rel="stylesheet" type="text/css">

        <!-- Meta Taggs -->
        <title><?php echo $__env->yieldContent('title'); ?> | <?php echo $companyData['name']??''; ?></title>
        <meta name="author" content="#website_title_here">
        <meta name="description" content="#website_meta_description_here">
        <meta name="keywords" content="#website_meta_keywords_here">
        <style type="text/css">
            .ui-autocomplete {
                width: auto !important;
            }

            .debit_amount {
                font-size: 14px;
                text-align: right;
                border: solid 1px red;
            }

            .credit_amount {
                font-size: 14px;
                text-align: right;
                border: solid 1px green;
            }
        </style>
        <?php echo $__env->yieldContent('css'); ?>
    </head>

    <body>
      

        <textarea class="editor user_note"></textarea>
        <textarea class="editor admin_note"></textarea>
        <!--start wrapper-->
        <div class="wrapper">
            <!--start top header-->
            <header class="top-header">
                <nav class="navbar navbar-expand">
                    <div class="mobile-toggle-icon d-xl-none">
                        <i class="bi bi-list"></i>
                    </div>
                    <div class="top-navbar d-none d-xl-block">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item me-3">
                                <b><?php echo $companyData['name'] ?? ''; ?></b>
                            </li>
                        </ul>
                    </div>
                    <form class="searchbar d-none d-xl-flex ms-auto">
                        <div class="position-absolute top-50 translate-middle-y search-icon ms-3"><i
                                class="bi bi-search"></i></div>
                        <input class="form-control sideMenusearchbar" type="text" placeholder="Type here to search">
                        <div class="position-absolute top-50 translate-middle-y d-block d-xl-none search-close-icon"><i
                                class="bi bi-x-lg"></i></div>
                    </form>
                    <div class=" d-none d-xl-flex ms-auto w-2" style="width: 20%;">
                        <select class="form-control" id="<?php echo request()->segment(1) == 'dashboard' ? 'user_financial_year' : ''; ?>" <?php echo request()->segment(1) == 'dashboard' ? '' : 'disabled'; ?>>
                            <option value="">Select Financial Year</option>
                            <?php $user_financial_year_id = \Session::get('user_financial_year_id') ?? ''; ?>
                            <?php $financialyear = \Session::get('financialyear') ?? ''; ?>

                            <?php $__currentLoopData = $financialyear; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo $value->financialyearid; ?>" <?php echo $user_financial_year_id == $value->financialyearid ? 'selected' : ''; ?>>Financial Year
                                    <?php echo $value->financial_year_name; ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="top-navbar-right ms-auto ms-md-0">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item dropdown dropdown-large">
                            </li>
                            <li class="nav-item dropdown dropdown-large">
                                <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="#"
                                    data-bs-toggle="dropdown">
                                    <div class="projects">
                                        <i class="bi bi-grid-3x3-gap-fill"></i>
                                    </div>
                                </a>
                                <div class="dropdown-menu dropdown-menu-end">
                                    <div class="row row-cols-3 gx-2">
                                        
                                        <?php $__currentLoopData = $quickMenuModules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(in_array($module['permission'], $authRolePermissions)): ?>
                                            <div class="col">
                                                <a
                                                    href="<?php echo e(isset($module['route']) && !empty($module['route']) ? url($module['route']) : '#'); ?>">
                                                    <div class="apps p-2 radius-5 text-center">
                                                        <div
                                                            class="apps-icon-box mb-1 text-white bg-danger bg-gradient">
                                                            <i
                                                                class="bi bi-<?php echo e(!empty($module['icon']) ? $module['icon'] : 'people-fill'); ?>"></i>
                                                        </div>
                                                        <p class="mb-0 apps-name"><?php echo !empty($module['menu_name']) ? $module['menu_name'] : 'people-fill'; ?></p>
                                                    </div>
                                                </a>
                                            </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </div>
                                    <!--end row-->
                                </div>
                            </li>
                            <li class="nav-item dropdown dropdown-small me-0">
                                <a class="nav-link dropdown-toggle dropdown-toggle-nocaret pe-0" href="#"
                                    data-bs-toggle="dropdown">
                                    <div class="user-setting d-flex align-items-center gap-1">
                                        <img src="<?php echo e(asset('admin/images/avtaar.png')); ?>" class="user-img"
                                            loading="lazy" alt="profile" width="32" height="32">
                                        <div class="user-name"><?php echo e(Auth::user()->name ?? ''); ?></div>
                                    </div>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    
                                    
                                    <li>
                                        <a class="dropdown-item" href="<?php echo e(url('signOut')); ?>">
                                            <div class="d-flex align-items-center">
                                                <div class="setting-icon"><i class="bi bi-lock-fill"></i></div>
                                                <div class="setting-text ms-2"><span>Logout</span></div>
                                            </div>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </nav>
            </header>
            <!--end top header-->
            <!--start sidebar -->

            <aside class="sidebar-wrapper" data-simplebar="true">
                <div class="sidebar-header">
                    <div>
                        
                        <?php if(isset($companyData['logo'])): ?>
                            <img src="<?php echo e($companyData['logo']?getPermanentUrl($companyData['logo']): 'https://metaminthealth.s3.ap-south-1.amazonaws.com/metamintassets/images/meta_mint_white_logo.png'); ?>" class="<?php if(isset($companyData->logo)): ?><?php echo e('logo-icons'); ?><?php else: ?><?php echo e('logo-icon'); ?><?php endif; ?>" alt="Favicon" style="width:100%">
                        <?php endif; ?>
                    </div>
                    
                    <div class="toggle-icon ms-auto"><i class="bi bi-chevron-double-left"></i></div>
                </div>
                <!--navigation-->

                <ul class="metismenu" id="menu">
                    <li>
                        <a href="<?php echo e(url('dashboard')); ?>">
                            <div class="parent-icon"><i class="bi bi-house-door"></i></div>
                            <div class="menu-title">Dashboard</div>
                        </a>
                    </li>
                    
                    <?php $__currentLoopData = $leftMenuModules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array($module['permission'], $authRolePermissions)): ?>
                            <li>
                                <a
                                    href="<?php echo e(isset($module['route']) && !empty($module['route']) ? url($module['route']) : '#'); ?>">
                                    <div class="parent-icon"><i
                                            class="bi bi-<?php echo e(!empty($module['icon']) ? $module['icon'] : 'people-fill'); ?>"></i>
                                    </div>
                                    <div class="menu-title"><?php echo !empty($module['menu_name']) ? $module['menu_name'] : 'people-fill'; ?></div>
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    

            <!-- <li>
               <a href="<?php echo e(route('inventory-stock.index')); ?>">
                  <div class="parent-icon"><i class="bi bi-<?php echo isset($module_icons) && isset($module_icons[149]) ? $module_icons[149]['icon'] : 'list'; ?>"></i>
                  </div>
                  <div class="menu-title"><?php echo 'Inventory & Stocks'; ?></div>
               </a>
            </li> -->

                </ul>
                <!--end navigation-->
            </aside>
            <!--end sidebar -->

            <!--start content-->
            <main class="page-content" style="margin-top:10px">
                <?php echo $__env->make('flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->yieldContent('pages'); ?>
            </main>
            <!--end page main-->

            <!--start overlay-->
            <div class="overlay nav-toggle-icon"></div>
            <!--end overlay-->

            <!--Start Back To Top Button-->
            <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
            <!--End Back To Top Button-->

            <!-- Modal -->
            <div class="modal fade" id="commonModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true"
                data-bs-backdrop="static" 
                data-bs-keyboard="false" >
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="commonModalLabel"></h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                        </div>
                        <div class="modal-footer text-center" style="justify-content: center;">
                            <button type="button" class="btn btn-primary save_button w-70"><i
                                    class="bx bx-save"></i> <span class="save_button_span"></span></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--end wrapper-->
        <!--plugins-->
        <script type="text/javascript" src="<?php echo e(asset('admin/js/jquery.min.js')); ?>"></script>


        
        <!-- Bootstrap bundle JS -->
        <script type="text/javascript" src="<?php echo e(asset('admin/js/bootstrap.bundle.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/js/moment.js')); ?>"></script>

        
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
        <!-- <script type="text/javascript" src="<?php echo e(asset('admin/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script> -->
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/select2/js/select2.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/datetimepicker/js/picker.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/datetimepicker/js/picker.time.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/datepicker/js/bootstrap-datepicker.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/easyPieChart/jquery.easypiechart.js')); ?>"></script>
        <!-- <script type="text/javascript" src="<?php echo e(asset('admin/plugins/apexcharts-bundle/js/apexcharts.min.js')); ?>"></script> -->
        <script type="text/javascript" src="<?php echo e(asset('admin/plugins/peity/jquery.peity.min.js')); ?>"></script>
        <!--app-->
        <script type="text/javascript" src="<?php echo e(asset('admin/js/pace.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/js/app.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/js/script.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('admin/js/script.js')); ?>"></script>

        <!-- custom js -->
        <script type="text/javascript" src="<?php echo e(asset('admin/js/custom.js')); ?>"></script>

        <script src="<?php echo e(asset('admin/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
        <script src="<?php echo e(asset('admin/plugins/datatables/dataTables.bootstrap4.min.js')); ?>"></script>

        <script type="text/javascript">
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            })
        </script>
        <script type="text/javascript">
            $(document).ready(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                    }
                });
                //Delay the action by 10000ms
                setTimeout(function() {
                    // Display the div containing the class "bottomdiv"
                    $(".fixed_contact_btn").show();
                    // $.switcher();
                }, 2000);
            });
        </script>
        <script type="text/javascript" src="<?php echo e(asset('admin/js/jquery.switcher.js')); ?>"></script>
        <script>
            $.switcher();
        </script>
        <script type="text/javascript">
            function toggle_div_fun(id) {
                var divelement = document.getElementById(id);
                if (divelement.style.display == 'none')
                    divelement.style.display = 'block';
                else
                    divelement.style.display = 'none';
            }
        </script>

        <script type="text/javascript" src="<?php echo e(asset('admin/js/jquery-ui.js')); ?>"></script>

        <?php echo $__env->yieldContent('js'); ?>

        <script type="text/javascript">
            $(document).on('click', '.show-help-support', function(event) {
                event.preventDefault();
                $('#commonModalLabel').text('Module Information:');
                $('.save_button_span').text('Close:');
                var module_id = $(this).data('id');
                var url = `<?php echo route('modules.help-text', ':id'); ?>`.replace(':id', module_id);

                $.ajax({
                    url: url,
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data.data);
                    }
                })
            });
        </script>
        <script type="text/javascript">
            $(document).on('input', "#priority", function() {
                //const onlyNumbers = $(this).val().replace(/[^0-9]/g, '');
                $("#priority").val(onlyNumbers);
            });
            $(document).on('input', "[name='priority']", function() {
                //const onlyNumbers = $(this).val().replace(/[^0-9]/g, '');
                $("[name='priority']").val(onlyNumbers);
            });
            $('#commonModal').on('shown.bs.modal', function() {
                $(this).find('.modal-body').find(':input:visible:not([disabled]):first').focus();
            });
            $(document).on('change', "#user_financial_year", function() {
                $.ajax({
                        url: '<?php echo route('submit-user-financial-year'); ?>',
                        data: {
                            _token: '<?php echo csrf_token(); ?>',
                            financialyear: $(this).val()
                        },
                        type: 'POST',
                        success: function(response) {
                            if (response.success === true) {
                                toastr.success(response.message, 'Success.');
                            } else {
                                toastr.error(response.message, 'Error!');
                            }
                        }
                    })
                    .fail(function(jqXHR, textStatus, errorThrown) {
                        console.log('AJAX request failed:', textStatus, errorThrown);
                        toastr.error('An error occurred during the request.', 'Error!');

                        // hide modal
                        $('#commonModal').modal('hide');
                        $('#commonModal').find('.modal-body').html('');
                    });
            });


            $(document).on('click', '#create-documents-management', function() {
                $('#commonModalLabel').text('Add New Document');
                $('.save_button_span').text('Save Document');

                var account_id = $(this).data('account_id') != undefined ? $(this).data('account_id') : '';
                var voucher_type = $(this).data('voucher_type') != undefined ? $(this).data('voucher_type') : '';

                $.ajax({
                    url: "<?php echo route('documents-management.create'); ?>?account=" + account_id + '&voucher=' + voucher_type,
                    success: function(data) {
                        $('#commonModal').find('.modal-body').html('');
                        $('#commonModal').find('.modal-body').html(data);

                        $('.single-select').select2({
                            dropdownParent: $('.modal'),
                            theme: 'bootstrap4',
                            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass(
                                'w-100') ? '100%' : 'style',
                            placeholder: $(this).data('placeholder'),
                            allowClear: Boolean($(this).data('allow-clear')),
                        });
                    }
                })
            });

            $(document).on('click', '.save_button', function(event) {
                event.preventDefault();

                if ($('#commonModal').find('form').hasClass('documents_management')) {
                    $('.error_priority').hide();
                    $('.error_attachment').hide();
                    $('.error_document_note').hide();

                    var error = 0;

                    if ($('#commonModal').find('form').find('input[name="attachment"]').val() == '' && !$(
                            '#commonModal').find('form').hasClass('edit')) {
                        $('.error_attachment').show();
                        error = 1;
                    }

                    if ($('#commonModal').find('form').find('input[name="priority"]').val().trim() == '') {
                        $('.error_priority').show();
                        error = 1;
                    }

                    if ($('#commonModal').find('form').find('[name="voucher_type"]').val() == '') {
                        $('.error_voucher_type').show();
                        error = 1;
                    }

                    if (error == 0) {
                        let formdata = new FormData($('#commonModal').find('form')[0]);

                        $.ajax({
                                url: $('#commonModal').find('form').attr('action'),
                                data: formdata,
                                processData: false,
                                contentType: false,
                                type: 'POST',
                                success: function(response) {
                                    if (response.success === true) {
                                        toastr.success(response.message, 'Success.');

                                        setTimeout(function() {
                                            location.reload();
                                        }, 2000);

                                        // hide modal
                                        $('#commonModal').modal('hide');
                                        $('#commonModal').find('.modal-body').html('');
                                    } else {
                                        toastr.error(response.message, 'Error!');
                                    }
                                }
                            })
                            .fail(function(jqXHR, textStatus, errorThrown) {
                                console.log('AJAX request failed:', textStatus, errorThrown);
                                toastr.error('An error occurred during the request.', 'Error!');

                                // hide modal
                                $('#commonModal').modal('hide');
                                $('#commonModal').find('.modal-body').html('');
                            });
                    }
                    error = 1;
                }
            })
        </script>
        <!-- Include this script at the end of your HTML file, just before the closing </body> tag -->
        <script>
            // $(document).on('keyup','.searchbar', function () {
            //     $(this).val();
            //     var input, filter, ul, li, a, i, txtValue;
            //     filter = $(this).val();
            //     ul = $("#metismenu");
            //     li = ul.find('li');

            //     // Loop through all list items, and hide those who don't match the search query
            //     for (i = 0; i < li.length; i++) {
            //         a = li[i].find("a");
            //         a = a.find(".menu-title");
            //         txtValue = a.textContent || a.innerText;
            //         if (txtValue.toUpperCase().indexOf(filter) > -1) {
            //         li[i].style.display = "";
            //         } else {
            //         li[i].style.display = "none";
            //         }
            //     }
            // });

            // $(document).on('keyup', '.searchbar', function () {
            //     var filter = $(this).val().toUpperCase();
            //     $("#metismenu").find('li').each(function () {
            //         var a = $(this).find("a .menu-title");
            //         var txtValue = a.text() || a.text();
            //         if (txtValue.toUpperCase().indexOf(filter) > -1) {
            //             $(this).show();
            //         } else {
            //             $(this).hide();
            //         }
            //     });
            // });

            // $(document).on('keyup', '.searchbar', function () {
            //     var filter = $(this).val().trim().toUpperCase(); // Get the value of the search bar and convert it to uppercase
            //     var ul = $("#menu");
            //     var li = ul.find('li');

            //     li.each(function () {
            //         var a = $(this).find("a");
            //         var txtValue = a.find(".menu-title").text().trim().toUpperCase(); // Get the text value of the menu item and convert it to uppercase

            //         // Show all list items if the filter is empty
            //         if (filter === "") {
            //             $(this).show();
            //             return;
            //         }

            //         if (txtValue.includes(filter)) { // Check if the menu item text contains the filter text
            //             $(this).show(); // Show the menu item if it matches the filter
            //         } else {
            //             $(this).hide(); // Hide the menu item if it doesn't match the filter
            //         }
            //     });
            // });
            $(document).on('keyup', '.sideMenusearchbar', function() {

                var filter = $('.sideMenusearchbar').val().trim().toUpperCase();

                var ul = $("#menu");
                var li = ul.find('li');

                li.each(function() {
                    var a = $(this).find("a");
                    var txtValue = a.find(".menu-title").text().trim().toUpperCase();

                    // Show all list items if the filter is empty
                    if (filter === "") {
                        $(this).show();
                        return;
                    }

                    if (txtValue.includes(filter)) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
        </script>

    </body>

</html>

<?php /**PATH C:\laragon\www\meta-mint-logistics\resources\views/layouts/app.blade.php ENDPATH**/ ?>